package com.mini.framework.util.generic.define;


import com.mini.framework.util.asserts.AssertUtil;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * string的set集合 这种写法是解决泛型带来的部分参数不明确的影响<BR>
 * 等价于<br>
 * @see Set<String>
 * @author jayheo
 */
public class SetString {

    /**
     * 初始值，不可以被修改的。
     */
    private final Set<String> value;

    public SetString(Set<String> value) {
        this.value = value;
    }

    public static SetString of(String... strings){
        return of(Stream.of(strings).collect(Collectors.toSet()));
    }

    public static SetString of(Set<String> set){
        AssertUtil.assertMethodRequire(set,"set");
        return new SetString(set);
    }

    public static SetString of(Collection<String> coll){
        return of(new HashSet<>(coll));
    }

    public static <B,B1> SetString of(Collection<B> coll, Function<B,B1> b1Getter, Function<B1,String> stringGetter){
        return of(coll,b1Getter.andThen(stringGetter));
    }


    public static <B> SetString of(Collection<B> coll, Function<B,String> stringGetter){
        return of(coll.stream()
                .map(stringGetter)
                .collect(Collectors.toSet()));
    }


    public static <B> SetString of(Function<B,String> stringGetter, Collection<B> coll){
        return of(coll,stringGetter);
    }

    /**
     * 复制出一个副本
     * @return
     */
    public SetString copy(){
        return SetString.of(out());
    }


    /**
     * 输出
     * @return
     */
    public Set<String> out(){
        return value;
    }


    /**
     * 返回一个stream
     * @return
     */
    public Stream<String> stream(){
        return value.stream();
    }


    /**
     * 判断是不是空的
     * @return
     */
    public boolean isEmpty(){
        return value.isEmpty();
    }


    /**
     * 判断是不是  非空。<BR>
     * 这里注意，对于  [null] 也代表是非空,<BR>
     * 我们的规范中，接受有  这样的数组 [null,""] 也就是list set map 等中不允许用 null，如果业务可能用就应该使用List<Optional<Bean>> 的方式<BR>
     * TODO 这段话要加入代码标准。
     * @return  空返回false 非空返回true
     */
    public boolean isNotEmpty(){
        return !this.isEmpty();
    }

}
