package com.mini.framework.util.increment;

import org.apache.commons.lang.math.RandomUtils;

/**
 * 增量规则
 * @author jayheo
 *
 */
public interface IncrementStrategy{

	
	/**
	 * 返回增量。
	 * @return
	 */
	default int stepIncrement(){
		return RandomUtils.nextInt(stepLimit()-stepOffset()) + stepOffset() ;
	};
	
	
	/**
	 * 返回最大限制
	 * @return
	 */
	int stepLimit();
	
	
	/**
	 * 返回最小值
	 * @return
	 */
	int stepOffset();
	
	
}
