package com.mini.framework.util.increment;

import com.mini.framework.core.exception.HandleStoreException;
import com.mini.framework.core.status.Status;

public class IncrementUtil {
	
	private IncrementStrategy incrementStrategy;
	
	private IncrementGenerator incrementGenerator;
	
	/**
	 * 如果出现冲突调动次数，越多越安全，建议是10左右。
	 */
	private int conflictAddTime =  10;
	
	private  String key; 
	
	
	public IncrementUtil( String key,IncrementStrategy incrementStrategy, IncrementGenerator incrementGenerator) {
		super();
		this.incrementStrategy= incrementStrategy;
		this.incrementGenerator = incrementGenerator;
		this.key = key;
	}
	
	public int getConflictAddTime() {
		return conflictAddTime;
	}

	public void setConflictAddTime(int conflictAddTime) {
		this.conflictAddTime = conflictAddTime;
	}

	public void  execute(IncrementStore incrementStore){
		int step = incrementStrategy.stepIncrement();
		long increment = incrementGenerator.nextIncrement(key, step);
		try{
			incrementStore.storeIncrement(key, increment);
		}catch(HandleStoreException e){
			if(e.statusCode() == Status.Handle.violateUnique.code()){
				long maxStore = incrementStore.showMaxStore(key);
				for (int i = 0; i < conflictAddTime; i++) {
					maxStore+=incrementStrategy.stepIncrement();
				}
				incrementGenerator.resetIncrement(key, maxStore);
				increment = incrementGenerator.nextIncrement(key, step);
				incrementStore.storeIncrement(key, increment);
			}
			throw e;
		}
	}
	
	
	/**
	 * 建造一个最简单的增量 策略
	 * @param offset
	 * @param limit
	 * @return
	 */
	public static IncrementStrategy buildSimpleStrategy(int offset, int limit){
		return new SimpleIncrementStrategy(offset, limit);
	}
}
