package com.mini.framework.util.ioc;

/**
 * 通过这个方法。可以解决内部调用导致的注解失效
 * @author jayheo
 */
public interface BeanInnerAopSupport<B extends BeanInnerAopSupport<?>> {

     /**
     * 显示当前的bean
     * 通过这个方法。可以解决内部调用导致的注解失效
     * 参考从示例代码。
     * <pre>
     public class BeanService{
    @Autowired
    @Lazy
    private BeanService beanService;
    showThisService(){
    return beanService;
    }
    }
     * }
     * </pre>
     * @return 返回本身
     * */
    B showThisBean();

}
