package com.mini.framework.util.log.trace;

import java.util.Optional;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternConverter;

/**
 * 扩展日志log4j2，转化器<br>
 * 这个本来是可以放到framework中但是测试发如果被打开spring-boot的lib包里居然找不到，<br>
 * 通过继承的方式也不可以，只能这样写。<br>
 * 希望以后的人能找到原因，解决这个问题。<br>
 * 放到spring-boot代码中本地跑起来又找不到，后来发现，放多一个也没有问题，所以现在两个地方都放算了 <br>
 */
@Plugin(name = "FrameworkExtendPatternConverter", category = PatternConverter.CATEGORY)
@ConverterKeys({ "aut" })
public class FrameworkExtendPatternConverter extends LogEventPatternConverter {
	
	private static final FrameworkExtendPatternConverter INSTANCE = new FrameworkExtendPatternConverter();

	public static FrameworkExtendPatternConverter newInstance(final String[] options) {
		return INSTANCE;
	}

	private FrameworkExtendPatternConverter() {
	super("aut", "ut-style");
	}

	@Override
	public void format(LogEvent event, StringBuilder toAppendTo) {
		Optional<Long> userTimeOptional = LinkTraceFace.countThreadUserTime(event.getContextData().toMap());
		toAppendTo.append(userTimeOptional.orElse(-1L));
	}
}