package com.mini.framework.util.oss;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.util.bean.desc.Descable;



/**
 * OSS 客户端的 配置
 *
 * @author jayheo*/
public class OssClientConfig implements Descable{

	/**
	 * 是不是走内网
	 * */
	private Boolean internalModel;


	/**
	 * 外网边缘节点
	 * 例:oss-cn-shanghai.aliyuncs.com
	 * */
	private String endpoint;
	/**
	 * vpc内网
	 * 例:vpc100-oss-cn-shanghai.aliyuncs.com
	 * */
	private String endpointInternal;
	/**
	 * 例:LTAIImBDk6fpZC7h
	 * */
	private String accessKeyId;
	/**
	 * 例:ndGKr4IfKlpNMpucywEbGp3t1yOW2L
	 * */
	private String accessKeySecret;

	private String bucketName;


	/**
	 * 读取数据的地址
	 * 例如:https://dmall-cdn.devaqk.com
	 * */
	private String readHome;


	public OssClientConfig(){

	}

	public OssClientConfig(Boolean internalModel, String endpoint,String endpointInternal, String accessKeyId, String accessKeySecret, String bucketName) {
		super();
		this.internalModel = internalModel;
		this.endpoint = endpoint;
		this.endpointInternal = endpointInternal;
		this.accessKeyId = accessKeyId;
		this.accessKeySecret = accessKeySecret;
		this.bucketName = bucketName;
	}

	public OssClientConfig(Boolean internalModel, String endpoint,String endpointInternal, String accessKeyId, String accessKeySecret, String bucketName,String readHome) {
		super();
		this.internalModel = internalModel;
		this.endpoint = endpoint;
		this.endpointInternal = endpointInternal;
		this.accessKeyId = accessKeyId;
		this.accessKeySecret = accessKeySecret;
		this.bucketName = bucketName;
		this.readHome = readHome;
	}
	public String getEndpoint() {
		return endpoint;
	}
	public void setEndpoint(String endpoint) {
		this.endpoint = endpoint;
	}
	public String getAccessKeyId() {
		return accessKeyId;
	}
	public void setAccessKeyId(String accessKeyId) {
		this.accessKeyId = accessKeyId;
	}
	public String getAccessKeySecret() {
		return accessKeySecret;
	}
	public void setAccessKeySecret(String accessKeySecret) {
		this.accessKeySecret = accessKeySecret;
	}
	public String getBucketName() {
		return bucketName;
	}
	public void setBucketName(String bucketName) {
		this.bucketName = bucketName;
	}
	public Boolean getInternalModel() {
		return internalModel;
	}
	public void setInternalModel(Boolean internalModel) {
		this.internalModel = internalModel;
	}
	public String getEndpointInternal() {
		return endpointInternal;
	}
	public void setEndpointInternal(String endpointInternal) {
		this.endpointInternal = endpointInternal;
	}

	public String getReadHome() {
		return readHome;
	}

	public void setReadHome(String readHome) {
		this.readHome = readHome;
	}

	/**
	 * 自动选择终端中
	 * @return
	 */
	public String autoEndpoint(){
		return internalModel? endpointInternal : endpoint;
	}



	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
