package com.mini.framework.util.oss;

import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Base64Utils;

import com.mini.framework.core.exception.BadDataException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.StringUtil;

public class OssWatermarkUtil {
	//panda.png (panda.png 经过URL安全base64编码后是：cGFuZGEucG5n)
	//Hello, 图片服务
	//https://help.aliyun.com/document_detail/44957.html?spm=5176.87240.400427.43.Ey8nyi
	
	private static Logger logger = LogManager.getLogger();
	/**
	 * 替换oss的水印
	 * 如果是图片水印，务必要求，图片的路径与url对应的资源在同一个oss bucket中
	 * @param url
	 * @param replaces
	 * @return
	 */
	public static String resetWatermark(String url,List<OssWatermarkReplace> replaces){
		//int prefixIndex = url.indexOf('/');
		String sureUrl = "/" + StringUtils.substringAfter(url, "/");
		Collections.sort(replaces);
		Collections.reverse(replaces);
		
		for (OssWatermarkReplace replace : replaces) {
			int beginIndex =  replace.getBase64Offset();
			int endIndex =  beginIndex+replace.getBase64Length();
			String watermark = replace.getWatermarkContent() ;
			String oldBase64 = sureUrl.substring(beginIndex, endIndex);
			//byte[] bytes = Base64Utils.decodeFromUrlSafeString(base64);
			//如果模板的url中有?x-oss-process的后缀就拿到后缀，没有的话返回""
			String suffix = getOssProcessSuffix(urlSafeDeBase64(oldBase64));
			AssertUtil.assertSupport(getOssProcessSuffix(watermark).length()==0,"水印素材[%s]不支持有process后缀",watermark);
			//根据水印规则，如果是图片水印，必须在一个bucket且，不能带域名，只是能后面的path。
			AssertUtil.assertSupport(!watermark.contains("http"),"水印内容:[%s]不能是完整的地址",watermark);
			//把后面加上 
 			String newBase64 = urlSafeBase64(watermark + suffix);
 			url = url.replace(oldBase64, newBase64);
		}
		return url;
	}
	
	
	private static String getOssProcessSuffix(String url){
		String ossProcessSuffix = "?x-oss-process";
		if(url.contains(ossProcessSuffix)){
			return url.substring(url.lastIndexOf(ossProcessSuffix));
		}else{
			return "";
		}
	}
	
	
	public static String urlSafeDeBase64(String base64){
		try{
			return new String( Base64Utils.decodeFromUrlSafeString(base64));
		}catch(IllegalArgumentException e){
			throw new BadDataException(e,"解密base64时发现错:%s",e.getMessage());
		}
	}
	
	
	public static String urlSafeBase64(String content){
		 return Base64Utils.encodeToUrlSafeString(StringUtil.getUtf8Byte(content)).replaceAll("=","");
	}
	

}
