package com.mini.framework.util.report.statistics;


import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

/**
 * 一个统计的工具
 * @author jayheo
 */
public interface Statistics extends ForkQueryable {


    /**
     * 显示统计的特征key
     * @return
     */
    String showStatisticsFeatureKey();




    /**
     * 预热所有持自然时间区域
     * @param dataStatisticsOffsetDate
     * @param limitDate
     * @param queryExecutor
     * @param exceptionHandle
     */
    static void hotWholeNativeRegion(Date dataStatisticsOffsetDate, Date limitDate, BiConsumer<TimeRegionUnit, DateRange> queryExecutor
            , Function<RuntimeException, Optional<RuntimeException>> exceptionHandle) {
        int maxRegion = 1000;
        Stream.of(TimeRegionUnit.hour,TimeRegionUnit.day,TimeRegionUnit.week,TimeRegionUnit.month,TimeRegionUnit.season,TimeRegionUnit.year)
                .forEach(timeUnit->{
                    Date dateRangeOffset = timeUnit.nearLazyFenceRangeDate(dataStatisticsOffsetDate);
                    Date dateRangeLimit = timeUnit.nearLazyFenceRangeDate(limitDate);
                    List<TimeRegionRange> nativeRegionFences = timeUnit.regionFences(dateRangeOffset, dateRangeLimit);

                    List<List<TimeRegionRange>> querySteps = new ArrayList<>();
                    while (nativeRegionFences.size()>maxRegion){
                        List<TimeRegionRange> oneStepRegions = nativeRegionFences.subList(0,maxRegion);
                        querySteps.add(new ArrayList<>(oneStepRegions));
                        oneStepRegions.clear();
                    }
                    querySteps.add(nativeRegionFences);
                    querySteps.stream()
                            .filter(regions->!regions.isEmpty())
                            .map(regions->{
                                LinkedList<TimeRegionRange> linked = new LinkedList<>(regions);
                                return DateRange.create(linked.getFirst().getOffset(),linked.getLast().getOffset());
                            }).forEach(dateRange->{
                        try{
                            queryExecutor.accept(timeUnit,dateRange);
                        }catch (RuntimeException e){
                            Optional<RuntimeException> exceptionOptional = exceptionHandle.apply(e);
                            //如果不要抛出异常就返回 empty 不要返回 null
                            AssertUtil.assertNotFatalBug(exceptionOptional != null,"不管什么情况 exceptionHandle 不能返回 null");
                            exceptionOptional.ifPresent(exception->{throw exception;});
                        }
                    });
                });
    }


}
