package com.mini.framework.util.report.statistics.protocol;

import java.util.Map;
import java.util.Optional;
import java.util.Set;

/**
 * 键字符串储存器
 */
public interface KeyStringValueStorage {

    /**
     * 覆盖储存 值和key
     * @param key
     * @param value
     */
    void coverSaveStringCache(String key, String value);


    /**
     * 通过key查询值，不一定能查询到值
     * @param key
     * @return
     */
    Optional<String> queryStringCacheByKey(String key);


    /**
     * 通过key批量查询值，不一定能查询到值
     * @param keys
     * @return
     */
    Map<String,String>queryBatchStringCacheByKeys(Set<String> keys);


}
