package com.mini.framework.util.report.statistics.summation.bean;

import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.CustomExceptionSupplier;
import com.mini.framework.util.report.statistics.protocol.DivideDenominatorNumeratorSummation;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author jayheo
 */
public class SummationElementAmount implements OneStatisticsResult, DivideDenominatorNumeratorSummation<SummationElementAmount> {


    private StatisticsResultMeta resultMeta;
    
    private ForkQueryProcess process;

    /**
     * 某个范围的记数
     */
    protected Long count;
    /**
     * 某个范围的求和
     */
    protected Long sum;

    /**
     * 某个范围内的最大值
     */
    protected Long max;


    /**
     * 某个范围内的最小值
     */
    protected Long min;

    /**
     * 放大一定数值。
     */
    protected Long expand;



    public SummationElementAmount() {
    }


    /**
     * 是不是有统计数据
     * @return
     */
    public boolean haveAmount(){
        return count != null && sum != null;
    }


    /*
     * 两个相除
     * @param expand
     * @param numerator
     * @param denominator
     * @param numeratorSum
     * @param denominatorSum
     * @return
     */
/*    public SummationElementAmount divideEachOther(long expand,SummationElementAmount numerator,SummationElementAmount denominator,
        boolean numeratorSum,boolean denominatorSum){
        //分子
        Long numeratorValue = numerator.showValueSumOrCount(numeratorSum);
        //分母
        Long denominatorValue = denominator.showValueSumOrCount(denominatorSum);
        //TODO 为什么要用double呢，这是防止long 溢出最大值
        long countOrSum = (long) (1.0 * numeratorValue / denominatorValue * expand);
        return new SummationElementAmount(countOrSum,countOrSum,null,null,expand);
    }*/


    /**
     * 除以另外一个数
     * @param expand
     * @param numeratorSum 分子是不是使用sum
     * @param denominatorSum 分母是不是使用sum
     * @param other
     */
    @Override
    public void mapperAmountDivideByOther(long expand,boolean numeratorSum,boolean denominatorSum,SummationElementAmount other){
        this.mergeOtherResultMeta(other);
        Long numeratorValue = this.showValueSumOrCount(numeratorSum);
        Long denominatorValue = other.showValueSumOrCount(denominatorSum);
        min = null;
        max = null;
        this.expand = expand;
        if(denominatorValue==0){
            count = null;
        }else{
            count = (long) (1.0 * numeratorValue / denominatorValue * expand);
        }
        sum = count;
    }

    @Override
    public void clearRedundancyFields(){
        //暂时没有要清楚的可以什么都不用做。
    }


    public Long showValueSumOrCount(boolean sumOrCount){
        return sumOrCount?sum:count;
    }

    public SummationElementAmount(Long count, Long sum, Long min, Long max, Long expand) {
        this.count = count;
        this.sum = sum;
        this.min = min;
        this.max = max;
        this.expand = expand;
    }

    public static SummationElementAmount createZeroEmpty(){
        return new SummationElementAmount(0L,0L,null,null, null);
    }


    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }



    public SummationElementAmount refAsSummationElementAmount(){
        return this;
    }

    /**
     * 得到一个基于 sum 的排序器
     * @param thenCount 是不是要使用count作为第二依据
     * @return 排序器
     */
    public static Comparator<SummationElementAmount> sorterBySum(boolean thenCount){
        Comparator<SummationElementAmount> sumSorter = Comparator.comparing(SummationElementAmount::getSum);
        if(thenCount){
            return sumSorter.thenComparing(SummationElementAmount::getCount);
        }
        return sumSorter;
    }

    /**
     * 得到一个基于 count 的排序器
     * @param thenSum 是不是要使用 sum 作为第二依据
     * @return 排序器
     */
    public static Comparator<SummationElementAmount> sorterByCount(boolean thenSum){
        Comparator<SummationElementAmount> countSorter = Comparator.comparing(SummationElementAmount::getCount);
        if(thenSum){
            return countSorter.thenComparing(SummationElementAmount::getSum);
        }
        return countSorter;
    }


    public static  <E extends CustomException> UnaryOperator<SummationElementAmount>
    validateRightFunction(CustomExceptionSupplier<E> exceptionSupplier) throws E{
        return amonut->amonut.validateRight(exceptionSupplier);
    }


    /**
     * 验证正确性
     * @param exceptionSupplier
     * @param <E>
     * @return
     * @throws E
     */
    public <E extends CustomException> SummationElementAmount validateRight(CustomExceptionSupplier<E> exceptionSupplier) throws E{
        validateComplete(exceptionSupplier);
        validateReasonable(exceptionSupplier);
        return this;
    }


    /**
     * 验证合理性。
     * 当count为0的时候也就是说没有任何记录，那么max 和 min 也不可能有。
     * @param exceptionSupplier
     * @param <E>
     * @return
     * @throws E
     */
    public <E extends CustomException> SummationElementAmount validateReasonable(CustomExceptionSupplier<E> exceptionSupplier) throws E{
        if(count == 0){
            // 这是一个种强烈验证，用来保证发现数据提前暴露出来
            if(max != null){
                throw exceptionSupplier.supply("max:[%s]不符合逻辑,因为当前count:[%s]，count为0说明没有数据也不可能有max,它应该为空",max,count);
            }
            if(min != null){
                throw exceptionSupplier.supply("min:[%s]不符合逻辑,因为当前count:[%s]，count为0说明没有数据也不可能有min,它应该为空",min,count);
            }
        }
        //后续还有合理性相关的验证在这里加
        return this;
    }


    public <E extends CustomException> SummationElementAmount validateComplete(CustomExceptionSupplier<E> exceptionSupplier) throws E{
        if(count == null){
            throw exceptionSupplier.supply("count 不能为空");
        }
        if(sum == null){
            throw exceptionSupplier.supply("sum 不能为空");
        }

        if((max == null) != (min==null)){
            //正常情况下不会存 有max没有min的，情况，如果存在说明数据有错误不符合框架要求，需要了解业务并修改返回值
            throw exceptionSupplier.supply("max:[%s] 和 min:[%s] 要么都为空要么都不为空",max,min);
        }
        //后续还有完整性相关的验证在这里加
        return this;
    }


    public static SummationElementAmount createEmptyInstance(){
        SummationElementAmount instance = new SummationElementAmount();
        instance.count = 0L;
        instance.sum = 0L;
        return instance;
    }

    /**
     * 把别的amount加到自己的上面
     * @param other
     * @return
     */
    public void mergeOtherAmount(SummationElementAmount other) {
        //TODO 这里必须断言  expand 是不是一致的。如果不一致应该统一。
        List<SummationElementAmount> amounts = Stream.of(this, other).collect(Collectors.toList());
        this.max = amounts.stream().map(SummationElementAmount::getMax).filter(Objects::nonNull).max(Long::compareTo).orElse(null);
        this.min = amounts.stream().map(SummationElementAmount::getMin).filter(Objects::nonNull).min(Long::compareTo).orElse(null);
        //按照目前的设计安排sum不允许为空，对于没什么任务记录的情况下，sum参考count一样当成 0
        this.sum = amounts.stream().mapToLong(SummationElementAmount::getSum).sum();
        this.count = amounts.stream().mapToLong(SummationElementAmount::getCount).sum();
    }



    /**
     * 两个amount 合成一个
     * @param amount1
     * @param amount2
     * @return
     */
    public static SummationElementAmount mergeAmount(SummationElementAmount amount1, SummationElementAmount amount2) {
        SummationElementAmount instance = SummationElementAmount.createEmptyInstance();
        instance.mergeOtherAmount(amount1);
        instance.mergeOtherAmount(amount2);
        return instance;
    }

    public StatisticsResultMeta getResultMeta() {
        return resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }


    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public ForkQueryProcess getProcess() {
        return process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public Long getMax() {
        return max;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public Long getMin() {
        return min;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public Long getCount() {
        return count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public Long getSum() {
        return sum;
    }

    public Long getExpand() {
        return expand;
    }

    public void setExpand(Long expand) {
        this.expand = expand;
    }

    public void setSum(Long sum) {
        this.sum = sum;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    /**
     * 复制到另外对象
     * @param other
     */
    public void copyToOther(SummationElementAmount other){
        other.min = min;
        other.max = max;
        other.count = count;
        other.sum = sum;
        other.process = process;
        other.resultMeta = resultMeta;
        other.expand = expand;
    }

}
