package com.mini.framework.util.require.bean;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 参数与实体属性组成的映射也就是对。 
 * @author jayheo
 *
 */
public class ParamFieldPair {

	private ParamSupplier paramSupplier;

	private FieldFinder fieldFinder;
	
	/**
	 *   FieldFinder 对应的 表达试。
	 *   比如 user.nick就是从用户中去昵称的表达式
	 */
	private String expression;

	public ParamFieldPair(String expression, ParamSupplier paramSupplier, FieldFinder fieldFinder) {
		super();
		AssertUtil.assertMethodRequire(paramSupplier, "paramSupplier");
		AssertUtil.assertMethodRequire(fieldFinder, "fieldFinder");
		this.expression = expression;
		this.paramSupplier = paramSupplier;
		this.fieldFinder = fieldFinder;
	}

	/**
	 * 执行查询器<br>
	 * 1，拿到参数。(比如说是用户id或者什么)<br>
	 * 2，使用查询器，拿到实体类型的实例。<br>
	 * 3，使用属性提取器，从实体类的实例中拿到某属性<br>
	 * @param queryer
	 * @return
	 */
	public Object execute(Queryer queryer) {
		Object param = paramSupplier.get();
		Object bean = queryer.query(param);
		Object field = fieldFinder.get(bean);
		return field;
	}

	public ParamSupplier getParamSupplier() {
		return paramSupplier;
	}

	public void setParamSupplier(ParamSupplier paramSupplier) {
		this.paramSupplier = paramSupplier;
	}

	public FieldFinder getFieldFinder() {
		return fieldFinder;
	}

	public void setFieldFinder(FieldFinder fieldFinder) {
		this.fieldFinder = fieldFinder;
	}

	public String getExpression() {
		return expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
	}

}
