package com.mini.framework.util.sql.view.bean;

import com.mini.framework.util.type.EnumTypeShower;

import java.util.Map;

/**
 * 对象的字符串
 * @author jayheo
 */
public enum ObjectStringValueType implements EnumTypeShower<ObjectStringValueType> {

    //TODO 需要优化一下每个 enum 的显示方便前端的使用

    /**
     * 日期
     */
    date("日期"),

    /**
     * 文本
     */
    text("文本"),

    /**
     * 整数
     */
    number("整数"),

    /**
     * 小数
     */
    decimal("小数"),

    /**
     * 图片
     * TODO 后续要添加 meta 信息，控制要显示的内容的属性
     */
    image("图片"),


    /**
     * 手机端url
     * 一般要弄个移动端显示
     */
    phoneUrl("手机端url"),


    /**
     * 桌面端url
     * 一般要弄个可以点击的按钮
     * */
    deskUrl("桌面端url"),


    /**
     * 某个进度
     * 一般来说是一个不大于1的浮点数
     */
    progress("进度"),


    /**
     * 二维状态
     * true/false
     */
    biStatus("二维状态"),


    /**
     * 分钱
     * 比如如果是1.2元，返回的数据实际是 120
     */
    centMoney("分钱"),


    //--------------------------以下不是原始数据需要再去查找---------------------------


    /**
     * 某个用户
     * TODO 后续要添加 meta 信息，控制要显示的内容的属性
     */
    user("某用户"),


    /**
     * 某个商品
     * TODO 后续要添加 meta 信息，控制要显示的内容的属性
     */
    goods("商品")

    ;

    private String title;

    ObjectStringValueType(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    @Override
    public void fillFieldToMap(Map<String, Object> map) {
        map.put("title",title);
    }
}
