package com.mini.framework.util.string;


import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.gson.Gson;
import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.exception.HandleStringException;
import com.mini.framework.core.exception.HandleStringJsonException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.bean.JsonPath;

public class JsonEditUtil {

	private static Logger logger = LogManager.getLogger(JsonEditUtil.class);

	public static void setJsonMapNamespaceValue(Map<String, Object> map, String[] namespace, String value) {
		if (namespace == null || namespace.length == 0) {
			throw new RuntimeException(String.format("从json map:[%s]中取数据参数为null", map));
		} else {
			String firstNamespace = namespace[0];
			if (namespace.length == 1) {
				map.put(firstNamespace, value);
			} else {
				@SuppressWarnings("unchecked")
				Map<String, Object> subMap = (Map<String, Object>) map.get(firstNamespace);
				setJsonMapNamespaceValue(subMap, Arrays.copyOfRange(namespace, 1, namespace.length), value);
			}
		}
	}

	public static String editJsonMapNamespaceValue(String mapFormatJson, String[] namespace, String value) {
		Gson gson = new Gson();
		@SuppressWarnings("unchecked")
		Map<String, Object> map = gson.fromJson(mapFormatJson, Map.class);
		setJsonMapNamespaceValue(map, namespace, value);
		String newJson = gson.toJson(map);
		newJson = lineCorrect(newJson);
		return newJson;
	}

	private static String lineCorrect(String lines) {
		if (lines != null) {
			lines = lines.replaceAll("\\\\r", "\r");
			lines = lines.replaceAll("\\\\n", "\n");
			lines = lines.replaceAll("\\\\u003c", "<");
			lines = lines.replaceAll("\\\\u003e", ">");
		}
		return lines;
	}

	@SuppressWarnings("unchecked")
	public static List<String> getJsonMapNamespaceValues(String json, String[]... namespaces) {
		Gson gson = new Gson();
		Map<String, Object> map = null;
		try {
			map = gson.fromJson(json, Map.class);
			return getJsonMapNamespaceValues(map, namespaces);
		} catch (Exception e) {
			throw new HandleStringJsonException(e,"在解析json时出错原json:%s", json);
		}
	}

	public static List<String> getJsonMapNamespaceValues(Map<String, Object> map, String[]... namespaces) {
		List<String> values = new ArrayList<String>();
		for (String[] namespace : namespaces) {
			String value = null;
			try {
				value = getJsonMapNamespaceValue(map, namespace);
			} catch (Exception e) {
				logger.error("从json中取值时出错将返回null并忽略,请检查数据,namespace:[{}]",StringUtils.join(namespace,"->"),e);
			}finally{
				values.add(value);
			}
		}
		if (values.size() != namespaces.length) {
			throw new HandleStringException("计算出的数据:%s长度与期望%s长度不一致", values, namespaces.length);
		}
		return values;
	}

	public static String getJsonMapNamespaceValue(Map<String, Object> map, String[] namespace) {
		if (namespace == null || namespace.length == 0) {
			throw new RuntimeException(String.format("从json:[%s]中取数据参数为null", map));
		} else {
			String name = namespace[0];
			Object object = map.get(name);
			if (namespace.length == 1) {
				if (object == null) {
					return null;
				} else {
					return object.toString();
				}
			} else {
				if (object instanceof Map) {
					@SuppressWarnings("unchecked")
					Map<String, Object> subMap = (Map<String, Object>) object;
					return getJsonMapNamespaceValue(subMap, Arrays.copyOfRange(namespace, 1, namespace.length));
				} else {// 如果他不是一个map就说明数据有问题
					throw new HandleStringException("map.%s不是一个map,map.keySet():%s,数据格式错误", name, map.keySet());
				}

			}
		}
	}

	@SuppressWarnings("unchecked")
	public static String getJsonMapNamespaceValue(String json, String[] namespace) {
		Gson gson = new Gson();
		Map<String, Object> map = null;
		try {
			map = gson.fromJson(json, Map.class);
			return getJsonMapNamespaceValue(map, namespace);
		} catch (Exception e) {
			throw new HandleStringJsonException(e,"在解析json时出错原namespace:%s原json:%s",
					StringUtils.join(namespace, ","), json);
		}
	}
	
	
	/**
	 * 填充对象数据
	 * @param json
	 * @param obj
	 */
	public static void fillStringValue(String json ,Object obj ){
		Field[] fields = obj.getClass().getDeclaredFields();
		for (Field field : fields) {
			JsonPath jsonPath =field.getAnnotation(JsonPath.class) ;
			if(jsonPath==null){
				continue;
			}
			AssertUtil.assertSupport(field.getType().equals(String.class), "属性%s必须是string",field);
			String[] namespace = jsonPath .value().split("\\.");
			String value = getJsonMapNamespaceValue(json, namespace );
			if(value==null){
				continue;
			}
			try {
				field.setAccessible(true);
				field.set(obj,value );
			} catch (IllegalArgumentException|IllegalAccessException e) {
				throw new BusyException(e, "不支持修改数据", obj);
			}
		};
	}
	
	public static String getJsonMapNamespaceValue(String json,String path){
		return getJsonMapNamespaceValue(json, path.split("\\."));
	}
	
	
}
