package com.mini.framework.util.string.bean;

import java.util.List;
import java.util.function.Function;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 通过正则匹配切割的字符中结果
 * 一般的数据会被切成  n个切点和n+1个数据断
 * 
 * @author jayheo
 *
 */
public class SplitItemPoint {
	/**
	 * 切开后的数据
	 */
	private List<String> items;

	/**
	 * 切点
	 */
	private List<String> points;

	public SplitItemPoint(List<String> items, List<String> points) {
		super();
		AssertUtil.assertMethodRequire(items, "items");
		AssertUtil.assertMethodRequire(points, "points");
		AssertUtil.assertSupport(items.size()==points.size() + 1,"分段数:[%s]应该是点数:[%s]加1",items.size(),points.size());
		this.items = items;
		this.points = points;
	}

	public List<String> getPoints() {
		return points;
	}

	public void setPoints(List<String> points) {
		this.points = points;
	}

	public List<String> getItems() {
		return items;
	}

	public void setItems(List<String> items) {
		this.items = items;
	}
	
	/**
	 * 修改所有的切点
	 * @param val
	 */
	public void setAllPoint(String val){
		for (int i = 0; i < getPoints().size(); i++) {
			getPoints().set(i,val);
		}
	}
	
	/**
	 * 遍历修改每个数据
	 * @param handler
	 */
	public void foreach(Function<String, String> handler){
		for (int i = 0; i < items.size(); i++) {
			items.set(i, handler.apply(items.get(i)));
		}
	}
	
	/**
	 * 按原来的顺序重新组装成字符串
	 * @return
	 */
	public String assem(){
		StringBuilder sb = new StringBuilder();
		sb.append( items.get(0));
		for (int i = 1; i < items.size(); i++) {
			sb.append(points .get(i-1));
			sb.append( items .get(i));
		}
		return sb.toString();
	}

	@Override
	public String toString() {
		String str = "";
		str += items.get(0);
		for (int i = 1; i < items.size(); i++) {
			str += "<";
			str += points .get(i-1);
			str += ">";
			str += items .get(i);
		}
		return str;
		
	}
	
}
