package com.mini.framework.util.string.json.flag;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 从json中去值 的路径标记
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface JsonPathMapping {


    /**
     * 对应的json路径，
     * 支持使用多个路径，如果第一个匹配不上就匹配第二个。
     * @return 多个可能的路径。
     */
    String[] value();

}
