/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.access;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.access.SimpleAccessBean;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;

public class BatchAccessUtil {
    public static <T> SimpleAccessBean createAccessToken(String key, int expireSeconds, List<T> paramList) {
        return BatchAccessUtil.createAccessToken(key, expireSeconds, BatchAccessUtil.toStringArray(paramList));
    }

    public static SimpleAccessBean createAccessToken(String key, int expireSeconds, String ... params) {
        Date expire = new Date(System.currentTimeMillis() + (long)(expireSeconds * 1000));
        return BatchAccessUtil.createAccessToken(key, expire, params);
    }

    public static SimpleAccessBean createAccessToken(String key, Date expire, String ... params) {
        String salt = "minidev";
        AssertUtil.assertMethodRequire(key, "key");
        AssertUtil.assertMethodRequire(expire, "expire");
        AssertUtil.assertMethodRequire(params, "params");
        AssertUtil.assertSupport(Stream.of(params).filter(param -> param == null).count() == 0L, "\u4e0d\u80fd\u6709\u53c2\u6570\u4e3a\u7a7a", new Object[0]);
        String sum = String.join((CharSequence)"-", (CharSequence[])ArrayUtils.addAll((Object[])new String[]{salt, key, expire.getTime() + ""}, (Object[])params));
        String token = DigestUtils.md5Hex((String)sum);
        return new SimpleAccessBean(key, token, expire, params);
    }

    private static boolean checkAccessToken(String token, String key, Date expire, String ... params) {
        SimpleAccessBean realAccessBean = BatchAccessUtil.createAccessToken(key, expire, params);
        return realAccessBean.getAccessToken().equals(token);
    }

    public static <T> void valiAccessToken(String token, String key, List<T> paramList) {
        BatchAccessUtil.valiAccessToken(token, key, BatchAccessUtil.toStringArray(paramList));
    }

    public static <T> void valiAccessToken(String token, String key, Integer ... params) {
        BatchAccessUtil.valiAccessToken(token, key, Arrays.asList(params));
    }

    public static void valiAccessToken(String token, String key, String ... params) {
        AssertUtil.assertMethodRequire(key, "key");
        SimpleAccessBean accessBean = new SimpleAccessBean(token);
        AssertUtil.assertNoBadReq(key.equals(accessBean.getAccessKey()), Status.BadReq.illParam, "accessKey\u5e94\u8be5\u4e3a:%s", key);
        BatchAccessUtil.valiAccessToken(accessBean, params);
    }

    private static void valiAccessToken(SimpleAccessBean accessBean, String ... params) {
        AssertUtil.assertMethodRequire(accessBean, "accessBean");
        BatchAccessUtil.valiAccessToken(accessBean.getAccessToken(), accessBean.getAccessKey(), accessBean.getExpireDate(), params);
    }

    private static <T> String[] toStringArray(List<T> paramList) {
        String[] params = paramList.stream().map(Object::toString).collect(Collectors.toList()).toArray(new String[0]);
        return params;
    }

    private static <T> void valiAccessToken(String token, String key, Date expire, List<T> paramList) {
        BatchAccessUtil.valiAccessToken(token, key, expire, BatchAccessUtil.toStringArray(paramList));
    }

    private static void valiAccessToken(String token, String key, Date expire, String ... params) {
        AssertUtil.assertMethodRequire(token, "token");
        AssertUtil.assertMethodRequire(key, "key");
        AssertUtil.assertMethodRequire(expire, "expire");
        AssertUtil.assertMethodRequire(params, "params");
        Date nowDate = new Date();
        boolean check = BatchAccessUtil.checkAccessToken(token, key, expire, params);
        AssertUtil.assertNoBadReq(nowDate.compareTo(expire) < 0, Status.BadReq.badbatchTokenExpire, "%s\u7684batchToken\u8fc7\u671f\u4e86(%s ms)", key, nowDate.getTime() - expire.getTime());
        AssertUtil.assertNoBadReq(check, Status.BadReq.badbatchToken, "batchToken\u65e0\u6548", new Object[0]);
    }
}

