/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.alert.exception;

import com.mini.framework.util.aspect.AspectBeanUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Pointcut;

public abstract class RabbitListenerExceptionHandleSupport {
    private static final Logger logger = LogManager.getLogger(RabbitListenerExceptionHandleSupport.class);

    @Pointcut(value="@annotation(org.springframework.amqp.rabbit.annotation.RabbitListener)")
    public void pointcut() {
    }

    @AfterThrowing(pointcut="pointcut()", throwing="exception")
    public void exceptionMark(JoinPoint joinPoint, Throwable exception) {
        String info = AspectBeanUtil.typeMethodArgsInfo(joinPoint);
        logger.error("found exception:{} on execute {}", (Object)exception.getMessage(), (Object)info, (Object)exception);
        try {
            this.mark(exception);
        }
        catch (Throwable e) {
            logger.debug("\u5ffd\u7565\u8bb0\u5f55\u65e5\u5fd7\u518d\u4ea7\u751f\u7684\u5f02\u5e38", e);
        }
    }

    protected abstract void mark(Throwable var1) throws Throwable;
}

