/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.code;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.code.DevCodeDescPoint;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DevCodeDescJavaFile {
    private String name;
    private String packagePath;
    private String projectName;
    private List<DevCodeDescPoint> points;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<DevCodeDescPoint> getPoints() {
        return this.points;
    }

    public void setPoints(List<DevCodeDescPoint> points) {
        this.points = points;
    }

    public static DevCodeDescJavaFile fromUtf8File(String filePath) {
        AssertUtil.assertMethodRequire(filePath, "filePath");
        return DevCodeDescJavaFile.fromUtf8File(new File(filePath));
    }

    public static DevCodeDescJavaFile fromUtf8File(File file) {
        AssertUtil.assertMethodRequire(file, "file");
        DevCodeDescJavaFile javaFile = new DevCodeDescJavaFile();
        javaFile.name = file.getName();
        javaFile.packagePath = file.getAbsolutePath();
        try {
            List lines = FileUtils.readLines((File)file, (String)"utf-8");
            javaFile.points = lines.stream().map(DevCodeDescPoint::fromLine).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return javaFile;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u8bfb\u6587\u4ef6:[%s]\u65f6\u51fa\u9519", new Object[]{file.getName()});
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

