/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.export.protocol;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.util.export.protocol.ExcelCellContentSupplier;
import com.mini.framework.util.string.StringUtil;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public interface ContentSupplier
extends ExcelCellContentSupplier {

    public static interface MoneyNumber
    extends ContentSupplier {
        public String supplier(long var1);

        @Override
        default public String supplier(Object origin) {
            this.assertNotNull(origin);
            if (origin instanceof Long) {
                return this.supplier((Long)origin);
            }
            if (origin instanceof String) {
                String originString = (String)origin;
                try {
                    long longValue = Long.parseLong(originString);
                    return this.supplier(longValue);
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedException("\u5982\u679c\u662f\u5b57\u7b26\u4e32\u5f53\u524d\u53ea\u652f\u6301\u80fd\u8f6c\u6210long\u578b\u7684\u6570\u636e,\u6570\u636e\u662f:[%s]", new Object[]{origin});
                }
            }
            if (origin instanceof Integer) {
                return this.supplier(((Integer)origin).longValue());
            }
            throw new UnsupportedException("\u5f53\u524d\u53ea\u652f\u6301long\u548cint\u578b\u7684\u6570\u636e\u800c\u4e0d\u662f:[%s]\u578b,\u6570\u636e\u662f:[%s]", new Object[]{origin.getClass(), origin});
        }

        public static interface FenOfYuan
        extends MoneyNumber {

            public static class CnyZhCn
            implements FenOfYuan {
                @Override
                public String supplier(long origin) {
                    return StringUtil.fen2yuan(origin) + "\u5143";
                }
            }
        }
    }

    public static interface DateLong
    extends ContentSupplier {
        public String supplier(long var1);

        @Override
        default public String supplier(Object origin) {
            this.assertNotNull(origin);
            if (origin instanceof Long) {
                return this.supplier((Long)origin);
            }
            if (origin instanceof String) {
                String originString = (String)origin;
                try {
                    long longValue = Long.parseLong(originString);
                    return this.supplier(longValue);
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedException("\u5982\u679c\u662f\u5b57\u7b26\u4e32\u5f53\u524d\u53ea\u652f\u6301\u80fd\u8f6c\u6210long\u578b\u7684\u6570\u636e,\u6570\u636e\u662f:[%s]", new Object[]{origin});
                }
            }
            throw new UnsupportedException("\u5f53\u524d\u53ea\u652f\u6301long\u578b\u7684\u6570\u636e\u800c\u4e0d\u662f:[%s]\u578b,\u6570\u636e\u662f:[%s]", new Object[]{origin.getClass(), origin});
        }

        public static class OnlyTime
        implements DateLong {
            @Override
            public String supplier(long origin) {
                return DateFormatUtils.format((Date)new Date(origin), (String)"HH:mm:ss");
            }
        }

        public static class OnlyDate
        implements DateLong {
            @Override
            public String supplier(long origin) {
                return DateFormatUtils.format((Date)new Date(origin), (String)"yyyy/MM/dd");
            }
        }

        public static class Full
        implements DateLong {
            @Override
            public String supplier(long origin) {
                return DateFormatUtils.format((Date)new Date(origin), (String)"yyyy/MM/dd HH:mm:ss");
            }
        }
    }
}

