/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.generic.define;

import com.mini.framework.util.generic.define.OptionalSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OptionalSetInteger
extends OptionalSet<Integer> {
    private static final OptionalSetInteger createEmpty() {
        return new OptionalSetInteger();
    }

    public static OptionalSetInteger ofNullable(Collection<Integer> collInteger) {
        return collInteger == null ? OptionalSetInteger.createEmpty() : OptionalSetInteger.of(collInteger);
    }

    public static OptionalSetInteger of(Collection<Integer> collInteger) {
        OptionalSetInteger set = new OptionalSetInteger();
        set.value = new LinkedHashSet<Integer>(collInteger);
        return set;
    }

    public static OptionalSetInteger ofNullable(Integer ... ts) {
        return ts == null ? OptionalSetInteger.createEmpty() : OptionalSetInteger.of(ts);
    }

    public static OptionalSetInteger of(Integer ... ts) {
        return OptionalSetInteger.of(Stream.of(ts).collect(Collectors.toSet()));
    }

    public static OptionalSetInteger ofNullable(String arr) {
        return arr == null ? OptionalSetInteger.createEmpty() : OptionalSetInteger.of(arr);
    }

    public static OptionalSetInteger of(String arr) {
        String[] integers = arr.split(",");
        List<Integer> list = Stream.of(arr.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        return OptionalSetInteger.of(list);
    }

    public Optional<Set<Integer>> out() {
        return this.out(false);
    }

    public Optional<Set<Integer>> outNotZero() {
        return this.out(true);
    }

    public Optional<Set<Integer>> out(boolean zeroAsNull) {
        if (zeroAsNull && this.value != null && this.value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.value);
    }

    public String toString() {
        return this.out().toString();
    }
}

