/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.generic.define;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.generic.define.StreamFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SetLong {
    private final Set<Long> value;

    public SetLong(Set<Long> value) {
        this.value = value;
    }

    public static SetLong empty() {
        return SetLong.of(new HashSet<Long>());
    }

    public static SetLong ofNullable(Long[] longsNullable) {
        return longsNullable == null ? SetLong.empty() : SetLong.of(longsNullable);
    }

    public static SetLong ofNullable(Set<Long> setNullable) {
        return setNullable == null ? SetLong.empty() : SetLong.of(setNullable);
    }

    public static SetLong of(Long ... longs) {
        return SetLong.of(Stream.of(longs).collect(Collectors.toSet()));
    }

    public static SetLong of(SetLong setLong1, SetLong setLong2, SetLong setLong3, SetLong setLong4) {
        return SetLong.of(SetLong.of(setLong1, setLong2), setLong3, setLong4);
    }

    public static SetLong of(SetLong setLong1, SetLong setLong2, SetLong setLong3) {
        return SetLong.of(SetLong.of(setLong1, setLong2), setLong3);
    }

    public static SetLong of(SetLong setLong1, SetLong setLong2) {
        List<Long> allSetLong = Stream.of(setLong1, setLong2).flatMap(SetLong::stream).collect(Collectors.toList());
        return SetLong.of(allSetLong);
    }

    public static SetLong of(SetLong setLong) {
        return SetLong.of(setLong.out());
    }

    public static SetLong of(Stream<Long> stream) {
        return SetLong.of(stream.collect(Collectors.toSet()));
    }

    public static <B> SetLong of(Stream<B> stream, Function<B, Long> longGetter) {
        return SetLong.of(stream.map(longGetter).collect(Collectors.toSet()));
    }

    public static SetLong of(Set<Long> set) {
        AssertUtil.assertMethodRequire(set, "set");
        return new SetLong(set);
    }

    public static SetLong of(Collection<Long> coll) {
        return SetLong.of(new HashSet<Long>(coll));
    }

    public static SetLong of(Collection<Long> coll, Predicate<Long> filter) {
        return SetLong.of(coll.stream().filter(filter).collect(Collectors.toSet()));
    }

    public SetLong filter(Predicate<Long> filter) {
        return SetLong.of(this.value.stream().filter(filter).collect(Collectors.toSet()));
    }

    public SetLong filterNonNull() {
        return this.filter(Objects::nonNull);
    }

    public static <L> SetLong of(Function<L, Long> longGetter, Collection<L> coll) {
        return SetLong.of(coll.stream().map(longGetter).collect(Collectors.toSet()));
    }

    public static <L> SetLong of(Collection<L> coll, Function<L, Long> longGetter) {
        return SetLong.of(coll.stream().map(longGetter).collect(Collectors.toSet()));
    }

    public static <L> SetLong of(Collection<L> coll, Function<L, Long> longGetter, Predicate<Long> filter) {
        return SetLong.of(coll, longGetter).filter(filter);
    }

    public static <L> SetLong ofFilter(Collection<L> coll, Predicate<L> filter, Function<L, Long> longGetter) {
        List<Long> longs = coll.stream().filter(filter).map(longGetter).collect(Collectors.toList());
        return SetLong.of(longs);
    }

    public static <L> SetLong of(Collection<L> coll, Function<L, Long> longGetter, Predicate<Long> filter, Predicate<Long> filter2) {
        return SetLong.of(coll, longGetter, filter).filter(filter2);
    }

    public static <L, B> SetLong of(Collection<L> coll, Function<L, B> beanGetter, Function<B, Long> longGetter) {
        return SetLong.of(coll, beanGetter.andThen(longGetter));
    }

    public static <L, B, B2> SetLong of(Collection<L> coll, Function<L, B> beanGetter, Function<B, B2> beanGetter2, Function<B2, Long> longGetter) {
        return SetLong.of(coll, beanGetter.andThen(beanGetter2).andThen(longGetter));
    }

    @Deprecated
    public static <L> SetLong of(Function<L, Long> longGetter, Collection<L> coll, Predicate<L> filter) {
        return SetLong.of(coll.stream().filter(filter).map(longGetter).collect(Collectors.toSet()));
    }

    @Deprecated
    public static <L> SetLong of(Function<L, Long> longGetter, Collection<L> coll, Predicate<L> filter, Predicate<Long> filter2) {
        return SetLong.of(coll.stream().filter(filter).map(longGetter).filter(filter2).collect(Collectors.toSet()));
    }

    public Long[] toArray() {
        return this.value.toArray(new Long[0]);
    }

    public SetLong intersect(SetLong other) {
        return SetLong.of(this.stream().filter(other::contains).collect(Collectors.toSet()));
    }

    public static Optional<SetLong> intersectAll(Collection<SetLong> setLongs) {
        ArrayList<SetLong> setLongList = new ArrayList<SetLong>(setLongs);
        return setLongList.stream().findFirst().map(first -> setLongList.stream().skip(1L).reduce(first, SetLong::intersect));
    }

    public SetLong union(SetLong ... others) {
        HashSet<Long> union = new HashSet<Long>(this.value);
        Stream.of(others).forEach(other -> union.addAll(other.value));
        return SetLong.of(union);
    }

    public static SetLong unionAll(Collection<SetLong> setLongs) {
        HashSet<Long> union = new HashSet<Long>();
        setLongs.forEach(setLong -> union.addAll(setLong.value));
        return SetLong.of(union);
    }

    public static <L> SetLong ofStreamFinder(StreamFinder<L, Long> longStreamFinder, Collection<L> coll) {
        return SetLong.of(coll.stream().flatMap(longStreamFinder::get).collect(Collectors.toSet()));
    }

    public static <L> SetLong ofStreamFinder(Collection<L> coll, StreamFinder<L, Long> longStreamFinder) {
        return SetLong.of(coll.stream().flatMap(longStreamFinder::get).collect(Collectors.toSet()));
    }

    public SetLong copy() {
        return SetLong.of(this.out());
    }

    public boolean contains(long target) {
        return this.value.contains(target);
    }

    public Set<Long> out() {
        return this.value;
    }

    public Stream<Long> stream() {
        return this.value.stream();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

