/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.oss.OssClientConfig;
import com.mini.framework.util.params.MapParams;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.RegexUtil;
import com.mini.framework.util.thread.ObjectThreadCachable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OssHelper {
    protected static Logger logger = LogManager.getLogger((String)OssHelper.class.getName());
    private ObjectThreadCachable<String> domainGetter;
    protected OssClientConfig occ;
    private String serverHome;

    public OssHelper(OssClientConfig occ, String serverHome) {
        this.occ = occ;
        this.serverHome = serverHome;
    }

    public String getServerHome() {
        return this.serverHome;
    }

    public Function<String, String> decomposeServerHomeTestRun() {
        return resUrl -> {
            AssertUtil.assertMethodRequire(resUrl, "resUrl");
            String namespace = RegexUtil.getUrlNamespace(resUrl);
            if (namespace == null) {
                return resUrl;
            }
            AssertUtil.assertNoBadReq(namespace.length() > 0, Status.BadReq.illParam, "resUrl:[%s]\u7684\u547d\u540d\u7a7a\u95f4\u4e0d\u80fd\u592a\u77ed", resUrl);
            return namespace.substring(1);
        };
    }

    public Function<String, String> decomposeServerHome() {
        return resUrl -> {
            AssertUtil.assertMethodRequire(resUrl, "resUrl");
            String namespace = RegexUtil.getUrlNamespace(resUrl);
            AssertUtil.assertNoBadReq(namespace != null, Status.BadReq.illParam, "resUrl:[%s]\u4e0d\u662f\u6b63\u5e38\u7684url\u4e0d\u80fd\u89e3\u6790\u51fa\u547d\u540d\u7a7a\u95f4", resUrl);
            AssertUtil.assertNoBadReq(namespace.length() > 0, Status.BadReq.illParam, "resUrl:[%s]\u7684\u547d\u540d\u7a7a\u95f4\u4e0d\u80fd\u592a\u77ed", resUrl);
            return namespace.substring(1);
        };
    }

    public String assemServerHome(String path) {
        AssertUtil.assertMethodRequire(path, "path");
        return this.serverHome + "/" + path;
    }

    public boolean matchServerHome(String url) {
        AssertUtil.assertMethodRequire(url, "url");
        return RegexUtil.getUrlDomain(this.serverHome).equals(RegexUtil.getUrlDomain(url));
    }

    public Function<String, String> sureMatchServerHome() {
        return url -> {
            AssertUtil.assertMethodRequire(url, "url");
            if (this.matchServerHome((String)url)) {
                return url;
            }
            return this.assemServerHome(this.uploadRes((String)url));
        };
    }

    public ObjectThreadCachable<String> getDomainGetter() {
        return this.domainGetter;
    }

    public void setDomainGetter(ObjectThreadCachable<String> domainGetter) {
        this.domainGetter = domainGetter;
    }

    private void quietShutdown(OSSClient client) {
        if (client != null) {
            try {
                client.shutdown();
            }
            catch (Throwable e) {
                logger.debug("\u5173\u95edoss\u5ba2\u6237\u7aef\u65f6\u51fa\u73b0\u5f02\u5e38", e);
            }
        }
    }

    public String uploadBase64(String base64, String extName) {
        AssertUtil.assertSupport(base64 != null, "base64\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Base64 base64Encoder = new Base64();
        try {
            return this.upload(base64Encoder.decode(base64), extName);
        }
        catch (RuntimeException e) {
            logger.error("\u5728\u5904\u7406base64\u8f6cbyte\u7684\u65f6\u5019\u51fa\u9519[{}],base64:[{}]", (Object)e.getMessage(), (Object)base64);
            throw new HandleIOException((Throwable)e, "\u5904\u7406base64\u5b57\u7b26\u4e32\u9519\u8bef", new Object[0]);
        }
    }

    public String uploadResWithHost(String urlString) {
        return this.assemServerHome(this.uploadRes(urlString));
    }

    public String uploadRes(String urlString) {
        AssertUtil.assertMethodRequire(urlString, "urlString");
        String extName = StringUtils.substringAfterLast((String)urlString, (String)".");
        extName = StringUtils.substringBefore((String)extName, (String)"?");
        if (extName.contains("/")) {
            logger.debug("\u4eceurl\u4e2d\u89e3\u6790\u4e0d\u51fa\u540e\u7f00url:[%s]", (Object)urlString);
            extName = "file";
        }
        AssertUtil.assertNoBadReq(extName.length() >= 0, Status.BadReq.illParam, "url:[%s]\u6ca1\u6709\u540e\u7f00\u4e0d\u80fd\u4f7f\u7528\u8fd9\u4e2a\u65b9\u6cd5", urlString);
        return this.uploadRes(urlString, extName);
    }

    public String uploadResRetainParams(String urlString) {
        String url = StringUtils.substringBefore((String)urlString, (String)"?");
        String params = StringUtils.substringAfter((String)urlString, (String)"?");
        String newUrl = this.uploadRes(url);
        if (StringUtils.contains((CharSequence)urlString, (CharSequence)"?")) {
            newUrl = newUrl + "?" + params;
        }
        return newUrl;
    }

    public String uploadRes(String urlString, String extName) {
        try {
            AssertUtil.assertSupport(urlString != null, "\u4e0a\u4f20\u8d44\u6e90\u65f6url\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
            return this.upload(new URL(urlString).openStream(), extName);
        }
        catch (FileNotFoundException e) {
            throw new BadReqException((Throwable)e, "\u8bf7\u6c42\u627e\u4e0d\u5230url:[%s]\u7c7b\u4f3c404", new Object[]{urlString});
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u8bf7\u6c42\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u65f6\u51fa\u9519,url:[%s]", new Object[]{urlString});
        }
    }

    public String upload(byte[] buf, String extName) {
        return this.upload(new ByteArrayInputStream(buf), extName);
    }

    public String upload(File file) {
        return this.upload(file, file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(File file, String extName) {
        String pathPrefix = this.parsePathPrefix();
        OSSClient client = null;
        try {
            String path = OssHelper.createObjectKey(pathPrefix, extName);
            client = new OSSClient(this.occ.autoEndpoint(), this.occ.getAccessKeyId(), this.occ.getAccessKeySecret());
            PutObjectResult result = client.putObject(this.occ.getBucketName(), path, file);
            this.markPutObjectResult(result);
            String string = path;
            this.quietShutdown(client);
            return string;
        }
        catch (Throwable throwable) {
            this.quietShutdown(client);
            throw throwable;
        }
    }

    private void markPutObjectResult(PutObjectResult result) {
        logger.debug(String.format("PutObject requestId:%s", result.getRequestId()));
    }

    private String parsePathPrefix() {
        return this.findPathPrefix().orElse("file/");
    }

    private Optional<String> findPathPrefix() {
        return Optional.ofNullable(this.domainGetter).map(getter -> {
            String prefix = (String)getter.get();
            AssertUtil.assertNormal(prefix != null, () -> new ServerException("domainGetter.get()\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
            return prefix;
        });
    }

    public BiFunction<String, String, String> uploadResSuffixFunction() {
        return (res, suffix) -> this.uploadRes((String)res, (String)suffix);
    }

    public Function<String, String> uploadResFunction() {
        return res -> this.uploadRes((String)res);
    }

    public Function<String, String> uploadOssResFunction() {
        return this.uploadResFunction().compose(this.assemServerHomeFunction());
    }

    public Function<String, String> assemServerHomeFunction() {
        return path -> this.assemServerHome((String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(InputStream inputStream, String extName) {
        String pathPrefix = this.parsePathPrefix();
        OSSClient client = null;
        try {
            String path = OssHelper.createObjectKey(pathPrefix, extName);
            client = new OSSClient(this.occ.autoEndpoint(), this.occ.getAccessKeyId(), this.occ.getAccessKeySecret());
            ObjectMetadata metadata = new ObjectMetadata();
            PutObjectResult result = client.putObject(this.occ.getBucketName(), path, inputStream, metadata);
            this.markPutObjectResult(result);
            String string = path;
            this.quietShutdown(client);
            return string;
        }
        catch (Throwable throwable) {
            this.quietShutdown(client);
            throw throwable;
        }
    }

    private static String createObjectKey(String pathPrefix, String extName) {
        AssertUtil.assertMethodRequire(pathPrefix != null, "pathPrefix\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertSupport(extName != null, "\u6587\u4ef6\u540e\u7f00\u540d\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        if (extName.contains(".")) {
            logger.debug(String.format("extName:%s\u4e2d\u542b\u6709.\u73b0\u53bb\u6389\u6700\u540e\u4e00\u4e2a\u70b9\u4ee5\u53ca\u4ee5\u524d\u7684\u5b57\u7b26", extName));
            extName = StringUtils.substringAfterLast((String)extName, (String)".");
        }
        String random = DateFormatUtils.format((Date)new Date(), (String)("yyyyMM/dd/yyyyMMddHHmmssSSS" + RandomStringUtils.randomNumeric((int)6)));
        String path = String.format("%s/%s.%s", pathPrefix, random, extName);
        logger.debug(String.format("OssHelper createRandomKey:%s", path));
        return path;
    }

    public MapParams grantAuthUpload(int expireSecond, String callbackUrl) {
        return this.grantAuthUpload(expireSecond, callbackUrl, mp -> {});
    }

    public MapParams grantAuthUpload(int expireSecond, String callbackUrl, Consumer<MapParams> callbackParamHandle) {
        String bucket = this.occ.getBucketName();
        String accessId = this.occ.getAccessKeyId();
        String accessKey = this.occ.getAccessKeySecret();
        String host = "https://" + bucket + "." + this.occ.getEndpoint();
        String datePath = DateFormatUtils.format((Date)new Date(), (String)"yyyyMM/dd/yyyyMMddHHmmssSSS");
        String randomPath = RandomStringUtils.randomNumeric((int)6);
        String ossDirPath = String.format("%s%s%s/", this.parsePathPrefix(), datePath, randomPath);
        OSSClient client = new OSSClient(this.occ.autoEndpoint(), accessId, accessKey);
        Date expireDate = DateUtils.addSeconds((Date)new Date(), (int)expireSecond);
        long fileSizeLimit = 10485760000L;
        long expireDateLong = expireDate.getTime();
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, fileSizeLimit);
        policyConds.addConditionItem(MatchMode.StartWith, "key", ossDirPath);
        String postPolicy = client.generatePostPolicy(expireDate, policyConds);
        byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = client.calculatePostSignature(postPolicy);
        MapParams callbackBody = MapParams.build("fileName", "${object}").param("size", "${size}").param("mimeType", "${mimeType}");
        callbackParamHandle.accept(callbackBody);
        MapParams resultMap = MapParams.build().param("fileSizeLimit", fileSizeLimit).param("expireDate", expireDate).param("accessid", accessId).param("policy", encodedPolicy).param("signature", postSignature).param("dir", ossDirPath).param("host", host).param("expire", expireDateLong);
        MapParams callbackParams = MapParams.build("callbackBodyType", "application/x-www-form-urlencoded").param("callbackUrl", callbackUrl).param("callbackBody", callbackBody.toUrlParams());
        String base64CallbackBody = BinaryUtil.toBase64String((byte[])GsonUtil.buildMilliSecondDateGson().toJson((Object)callbackParams).getBytes());
        resultMap.put("callback", base64CallbackBody);
        MapParams devDesc = MapParams.build("desc", "\u5728\u4f7f\u7528\u8fd9\u4e2a\u63a5\u53e3\u7684\u65f6\u5019\u52a1\u5fc5\u8981\u5c06\u5f53\u524d\u4f7f\u7528\u7684bucket\u8bbe\u7f6e\u53ef\u4ee5\u8de8\u57dfpost\u8bbf\u95ee,\u5426\u5219\u4f1a\u51fa\u6765403\u9519\u8bef").param("bucket", bucket).param("bucketHost", host).param("setPost", "\u8fdb\u5165\u963f\u91cc\u4e91\u63a7\u5236\u53f0oss\u63a7\u5236\u53f0\u8fdb\u5165\u5bf9\u5e94bucket->\u57fa\u7840\u8bbe\u7f6e->\u8de8\u57df\u8bbe\u7f6e\u6dfb\u52a0post\u5141\u8bb8\u89c4\u5219,\u4ee5\u4e0b\u662f \u4e0a\u6d77 \u8282\u70b9\u7684\u8bbe\u7f6e\u5730\u5740").param("setPostUrl", String.format("https://oss.console.aliyun.com/bucket/oss-cn-shanghai/%s/settings/cors", bucket));
        resultMap.param("devDesc", devDesc);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPath(String path, String newPath) {
        logger.debug("\u5f00\u59cbresetPath path:{},newPath:{}", (Object)path, (Object)newPath);
        OSSClient client = null;
        try {
            client = new OSSClient(this.occ.autoEndpoint(), this.occ.getAccessKeyId(), this.occ.getAccessKeySecret());
            client.copyObject(this.occ.getBucketName(), path, this.occ.getBucketName(), newPath);
            client.deleteObject(this.occ.getBucketName(), path);
            this.quietShutdown(client);
        }
        catch (Throwable throwable) {
            this.quietShutdown(client);
            throw throwable;
        }
        logger.debug("\u7ed3\u675fresetPath path:{},newPath:{}", (Object)path, (Object)newPath);
    }

    public String resetPathAuto(String path) {
        String extName = StringUtils.substringAfterLast((String)path, (String)".");
        String newPath = OssHelper.createObjectKey(this.parsePathPrefix(), extName);
        this.resetPath(path, newPath);
        return newPath;
    }
}

