/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.oss;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.SimpleHttpUtil;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.PicInfo;
import com.mini.framework.util.oss.bean.StringPicInfo;
import com.mini.framework.util.string.JsonEditUtil;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OssPicUtil {
    private static Logger logger = LogManager.getLogger(OssPicUtil.class);

    public static String resizePercent(String ossUrl, int percent) {
        String split = ossUrl.contains("?") ? "," : "?";
        String newUrl = String.format("%s%sx-oss-process=image/resize,p_%s", ossUrl, split, percent);
        return newUrl;
    }

    public static String toSizeLogo(String ossUrl, int size) {
        String split = ossUrl.contains("?") ? "," : "?";
        String newUrl = String.format("%s%sx-oss-process=image/resize,m_fill,h_%s,w_%s", ossUrl, split, size, size);
        return newUrl;
    }

    public static String tryToAverageColer(String ossUrl) {
        String split = ossUrl.contains("?") ? "," : "?";
        String newUrl = String.format("%s%sx-oss-process=image/average-hue", ossUrl, split);
        try {
            String resp = SimpleHttpUtil.simpleGet(newUrl);
            String rgb = JsonEditUtil.getJsonMapNamespaceValue(resp, new String[]{"RGB"});
            return rgb;
        }
        catch (Exception e) {
            logger.debug("\u6839\u636eurl:{}\u6ca1\u6709\u5f97\u5230\u5e73\u5747\u8272", (Object)ossUrl);
            return null;
        }
    }

    public static Optional<PicInfo> tryQueryBaseInfo(String ossUrl) {
        try {
            return Optional.ofNullable(OssPicUtil.findBaseInfo(ossUrl));
        }
        catch (Exception e) {
            logger.debug("\u4eceossUrl:{}\u89e3\u6790\u4e0d\u51fa\u56fe\u7247\u5c3a\u5bf8", (Object)ossUrl, (Object)e);
            return Optional.empty();
        }
    }

    @Deprecated
    public static PicInfo tryFindBaseInfo(String ossUrl) {
        return OssPicUtil.tryQueryBaseInfo(ossUrl).orElse(null);
    }

    public static PicInfo findBaseInfo(String ossUrl) {
        AssertUtil.assertMethodRequire(ossUrl, "ossUrl");
        String split = ossUrl.contains("?") ? "," : "?";
        String newUrl = String.format("%s%sx-oss-process=image/info", ossUrl, split);
        String resp = SimpleHttpUtil.simpleGet(newUrl);
        StringPicInfo stringPicInfo = new StringPicInfo();
        JsonEditUtil.fillStringValue(resp, stringPicInfo);
        PicInfo picInfo = new PicInfo();
        picInfo.setFileSize(Integer.parseInt(stringPicInfo.getFileSize()));
        picInfo.setHeight(Integer.parseInt(stringPicInfo.getHeight()));
        picInfo.setWidth(Integer.parseInt(stringPicInfo.getWidth()));
        picInfo.setFormat(stringPicInfo.getFormat());
        return picInfo;
    }

    public static String cutBottom(String ossUrl, int widthRatio, Function<String, String> ossUrlResave) {
        OssImageProcessParams webpProcess = OssImageProcessParams.formatWebpProcess();
        ossUrl = webpProcess.applyParams(ossUrl);
        if (ossUrl.contains("x-oss-process")) {
            ossUrl = ossUrlResave.apply(ossUrl);
        }
        PicInfo picInfo = OssPicUtil.findBaseInfo(ossUrl);
        int height = picInfo.getHeight();
        int width = picInfo.getWidth();
        int cutHeight = width * widthRatio / 100;
        OssImageProcessParams cutProcess = OssImageProcessParams.crossCutProcess(0, height - cutHeight, width);
        OssImageProcessParams format = OssImageProcessParams.formatProcess("jpg");
        String preResult = OssImageProcessParams.applyMultiParams(ossUrl, cutProcess, format);
        return ossUrlResave.apply(preResult);
    }

    public static String appendBottomWhite(String ossUrl, int widthRatio, Function<String, String> ossUrlResave) {
        int width;
        int appendHeight;
        PicInfo picInfo;
        int height;
        if ((ossUrl = OssImageProcessParams.formatWebp(ossUrl)).contains("x-oss-process")) {
            ossUrl = ossUrlResave.apply(ossUrl);
        }
        AssertUtil.assertNoBadReq((height = (picInfo = OssPicUtil.findBaseInfo(ossUrl)).getHeight().intValue()) + (appendHeight = (width = picInfo.getWidth().intValue()) * widthRatio / 100) * 2 <= 4096, Status.BadReq.illParam, "\u5c3a\u5bf8:[%s]\u592a\u5927\u4e0d\u80fd\u8d85\u8fc74096", height + appendHeight * 2);
        OssImageProcessParams firstProcess = new OssImageProcessParams("resize", "m", "pad", "color", "FFFFFF").param("limit", 0).param("w", width).param("h", height + appendHeight * 2);
        OssImageProcessParams secondProcess = OssImageProcessParams.crossCutProcess(appendHeight, height + appendHeight, width);
        String bottomWhiteOssUrl = OssImageProcessParams.applyMultiParams(ossUrl, firstProcess, secondProcess);
        String bottomWhiteOssUrlJpg = OssImageProcessParams.formatProcess("jpg").applyParams(bottomWhiteOssUrl);
        String result = ossUrlResave.apply(bottomWhiteOssUrlJpg);
        return result;
    }

    public static String downShadeBlur(String ossPath, int width, int realPercent, int shadePercent, int shadeFine, Function<String, String> ossResave) {
        Function<Integer, OssImageProcessParams> blurProcessGetter = size -> new OssImageProcessParams("blur", "r", (int)size, "s", (int)size);
        int shadeBegin = width * 16 * realPercent / 900;
        int shadeEnd = width * 16 * (realPercent + shadePercent) / 900;
        OssImageProcessParams baseModelProcess = new OssImageProcessParams("resize", "m", "lfit").param("w", width);
        String bottomOssPath = OssImageProcessParams.applyMultiParams(ossPath, baseModelProcess, blurProcessGetter.apply(50), baseModelProcess, blurProcessGetter.apply(50), baseModelProcess, blurProcessGetter.apply(50), baseModelProcess, blurProcessGetter.apply(50), baseModelProcess, blurProcessGetter.apply(50));
        String realCutOssPath = OssImageProcessParams.applyMultiParams(ossPath, baseModelProcess, OssImageProcessParams.crossCutProcess(0, shadeBegin, width));
        bottomOssPath = OssImageProcessParams.applyMultiParams(bottomOssPath, OssImageProcessParams.crossDownImageWatermarkProcess(realCutOssPath, 0, 0));
        for (int step = 0; step < shadeFine; ++step) {
            if (step == 10) {
                bottomOssPath = ossResave.apply(bottomOssPath);
            }
            int transparent = 100 * (step + 1) / shadeFine;
            int cutOffset = shadeBegin + (shadeEnd - shadeBegin) * step / shadeFine;
            int cutToset = shadeBegin + (shadeEnd - shadeBegin) * (step + 1) / shadeFine;
            int cutLimit = cutToset - cutOffset;
            String halfCutOssPath = OssImageProcessParams.applyMultiParams(ossPath, baseModelProcess, OssImageProcessParams.crossCutProcess(cutOffset, cutLimit, width));
            bottomOssPath = OssImageProcessParams.applyMultiParams(bottomOssPath, OssImageProcessParams.crossDownImageWatermarkProcess(halfCutOssPath, cutOffset, transparent));
        }
        return ossResave.apply(bottomOssPath);
    }
}

