/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.ranking.bean;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateRange;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.report.statistics.protocol.RankingDimension;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class NativeDateScoreRankingScheme {
    private RankingDimension dimension;
    private String paramsSerialize;
    private String paramsSerializeMd5;
    private String rankingKey;
    private Date regionOffset;
    private TimeRegionUnit regionUnit;
    private String regionUnionKey;
    private Date touchUpperLimit;
    private Integer cacheItemLimit;
    private Boolean touchFullyScope;

    public static NativeDateScoreRankingScheme createByBasicField(RankingDimension dimension, TimeRegionUnit regionUnit, Date regionOffset, String paramsSerializeMd5, int cacheItemLimit, String paramsSerialize) {
        NativeDateScoreRankingScheme instance = new NativeDateScoreRankingScheme();
        instance.dimension = dimension;
        instance.paramsSerialize = paramsSerialize;
        instance.paramsSerializeMd5 = paramsSerializeMd5;
        instance.regionOffset = regionOffset;
        instance.regionUnit = regionUnit;
        instance.cacheItemLimit = cacheItemLimit;
        instance.rankingKey = UUID.randomUUID().toString();
        instance.regionUnionKey = instance.countRegionUnionKey();
        instance.touchUpperLimit = instance.regionOffset;
        instance.touchFullyScope = false;
        return instance;
    }

    public Optional<DateRange> countRequireTouchRange(Date touchUpperPoint) {
        AssertUtil.assertMethodRequire(touchUpperPoint, "touchUpperPoint");
        Date offset = this.touchUpperLimit != null ? this.touchUpperLimit : this.regionOffset;
        Date rangeLimitDate = this.regionUnit.addTimeUnit(this.regionOffset, 1);
        Date limit = rangeLimitDate.before(touchUpperPoint) ? rangeLimitDate : touchUpperPoint;
        return Optional.of(DateRange.create(offset, limit)).filter(DateRange::haveTimeScope);
    }

    public boolean ifTouchRangeUpperLimit(Date touchUpperPoint) {
        AssertUtil.assertMethodRequire(touchUpperPoint, "touchUpperPoint");
        Date rangeLimitDate = this.regionUnit.addTimeUnit(this.regionOffset, 1);
        return !rangeLimitDate.after(touchUpperPoint);
    }

    public String countRegionUnionKey() {
        return NativeDateScoreRankingScheme.countRegionUnionKey(this.regionUnit, this.regionOffset);
    }

    public static String countRegionUnionKey(TimeRegionUnit regionUnit, Date regionOffset) {
        return String.format("%s-%s", regionUnit, DateUtil.toSecondsString(regionOffset));
    }

    public boolean ifNotTouchFullyScope() {
        return this.ifNotTouchFullyScope();
    }

    public boolean ifTouchFullyScope() {
        return Optional.ofNullable(this.touchFullyScope).orElse(false);
    }

    public String getRankingKey() {
        return this.rankingKey;
    }

    public void setRankingKey(String rankingKey) {
        this.rankingKey = rankingKey;
    }

    public Date getRegionOffset() {
        return this.regionOffset;
    }

    public void setRegionOffset(Date regionOffset) {
        this.regionOffset = regionOffset;
    }

    public TimeRegionUnit getRegionUnit() {
        return this.regionUnit;
    }

    public void setRegionUnit(TimeRegionUnit regionUnit) {
        this.regionUnit = regionUnit;
    }

    public Date getTouchUpperLimit() {
        return this.touchUpperLimit;
    }

    public void setTouchUpperLimit(Date touchUpperLimit) {
        this.touchUpperLimit = touchUpperLimit;
    }

    public String getRegionUnionKey() {
        return this.regionUnionKey;
    }

    public void setRegionUnionKey(String regionUnionKey) {
        this.regionUnionKey = regionUnionKey;
    }

    public Boolean getTouchFullyScope() {
        return this.touchFullyScope;
    }

    public void setTouchFullyScope(Boolean touchFullyScope) {
        this.touchFullyScope = touchFullyScope;
    }

    public String getParamsSerialize() {
        return this.paramsSerialize;
    }

    public void setParamsSerialize(String paramsSerialize) {
        this.paramsSerialize = paramsSerialize;
    }

    public String getParamsSerializeMd5() {
        return this.paramsSerializeMd5;
    }

    public void setParamsSerializeMd5(String paramsSerializeMd5) {
        this.paramsSerializeMd5 = paramsSerializeMd5;
    }

    public RankingDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(RankingDimension dimension) {
        this.dimension = dimension;
    }

    public Integer getCacheItemLimit() {
        return this.cacheItemLimit;
    }

    public void setCacheItemLimit(Integer cacheItemLimit) {
        this.cacheItemLimit = cacheItemLimit;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

