/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.ranking.bean;

import com.google.gson.Gson;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.ranking.bean.RankingElementSummationAmount;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;

public class StatisticsRankingTable<E extends RankingElementSummationAmount<E>>
implements OneStatisticsResult {
    private StatisticsResultMeta resultMeta;
    private ForkQueryProcess process;
    private Integer size;
    private List<E> elements;

    public static <T extends RankingElementSummationAmount<T>> StatisticsRankingTable<T> create(List<T> elements) {
        StatisticsRankingTable instance = new StatisticsRankingTable();
        instance.elements = elements;
        instance.sureRightSize();
        return instance;
    }

    public Optional<E> findSameElementByElement(E other) {
        return this.findSameElementByKey(((RankingElementSummationAmount)other).getCountKey());
    }

    public Optional<E> findSameElementByKey(String countKey) {
        return this.elements.stream().filter(element -> element.matchKey(countKey)).findFirst();
    }

    public void accumulateOtherElement(Function<String, E> instanceSupplier, E other) {
        Optional<E> existOptional = this.findSameElementByElement(other);
        existOptional.ifPresent(element -> element.mergeOtherHandleImplElement(other));
        if (!existOptional.isPresent()) {
            this.elements.add(RankingElementSummationAmount.copyNewInstance(instanceSupplier, other));
        }
        this.sureRightSize();
        this.sorterDesc();
    }

    public static <A extends RankingElementSummationAmount<A>> BinaryOperator<StatisticsRankingTable<A>> reduceAccumulator(Function<String, A> instanceSupplier) {
        return (ranking1, ranking2) -> StatisticsRankingTable.accumulateRankings(instanceSupplier, ranking1, ranking2);
    }

    public static <A extends RankingElementSummationAmount<A>> StatisticsRankingTable<A> accumulateRankings(Function<String, A> instanceSupplier, StatisticsRankingTable<A> ranking1, StatisticsRankingTable<A> ranking2) {
        StatisticsRankingTable ranking = StatisticsRankingTable.createEmpty();
        Stream.of(ranking1, ranking2).flatMap(StatisticsRankingTable::stream).forEach(element -> ranking.accumulateOtherElement(instanceSupplier, element));
        ranking.mergeOtherResultMeta(ranking1);
        ranking.mergeOtherResultMeta(ranking2);
        return ranking;
    }

    public StatisticsRankingTable<E> retainLimitHead(Optional<Integer> headOptional) {
        headOptional.ifPresent(head -> this.retainLimitHead((int)head));
        return this;
    }

    public StatisticsRankingTable<E> sureRightSize() {
        this.size = this.elements.size();
        return this;
    }

    public StatisticsRankingTable<E> retainLimitHead(int head) {
        Iterator<E> it = this.elements.iterator();
        int index = 0;
        while (it.hasNext() && index++ < head) {
            it.next();
        }
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        return this.sureRightSize();
    }

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(this.resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public static <E extends RankingElementSummationAmount<E>> StatisticsRankingTable<E> createEmpty() {
        return StatisticsRankingTable.create(new ArrayList());
    }

    public static <A extends RankingElementSummationAmount<A>> StatisticsRankingTable<A> deserialize(String serializeString, A bean) {
        return bean.deserializeJsonRankingTable(serializeString);
    }

    public <A extends RankingElementSummationAmount<A>> String serialize(A bean) {
        return RankingElementSummationAmount.createGsonBean(bean).toJson((Object)this);
    }

    public Stream<E> stream() {
        return this.elements.stream();
    }

    public static Gson createGsonBean(RankingElementSummationAmount<?> amount) {
        return amount.createGsonBuilder().create();
    }

    public String serializeJson(RankingElementSummationAmount<E> amount) {
        return amount.createGsonBuilder().create().toJson((Object)this);
    }

    public static StatisticsRankingTable deserializeJson(RankingElementSummationAmount<?> bean, String json) {
        return (StatisticsRankingTable)StatisticsRankingTable.createGsonBean(bean).fromJson(json, StatisticsRankingTable.class);
    }

    public StatisticsResultMeta getResultMeta() {
        return this.resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public ForkQueryProcess getProcess() {
        return this.process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    @Override
    public void clearRedundancyFields() {
        if (this.elements != null) {
            this.elements.forEach(OneStatisticsResult::clearRedundancyFields);
        }
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(this.process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public List<E> getElements() {
        return this.elements;
    }

    public void setElements(List<E> elements) {
        this.elements = elements;
    }

    public void sorterDesc() {
        this.elements.sort(RankingElementSummationAmount.rankingSorterDesc());
    }
}

