/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string.gson.format;

import com.mini.framework.util.string.gson.format.CommandParamsDescribe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class CommandParams {
    public static final String commandArgsSplit = ",";
    public static final String commandExplainSplitRegex = "\\||/";
    private String name;
    private String[] args;
    private String line;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public CommandParams() {
    }

    public static CommandParams createFromFunctionParams(String name, String ... args) {
        return new CommandParams(name, args, String.format("%s,%s", name, String.join((CharSequence)commandArgsSplit, args)));
    }

    public CommandParams(String name, String[] args, String line) {
        this.name = name;
        this.args = args;
        this.line = line;
    }

    public static List<CommandParamsDescribe> resolverExplainWithDescribe(String explain) {
        return CommandParams.resolverExplain(explain).stream().map(CommandParamsDescribe::createFromCommand).collect(Collectors.toList());
    }

    public static List<CommandParams> resolverExplain(String explain) {
        String[] commandSteps;
        ArrayList<CommandParams> commandParamsList = new ArrayList<CommandParams>();
        for (String commandStep : commandSteps = explain.split(commandExplainSplitRegex)) {
            Object[] commands = commandStep.split(commandArgsSplit);
            String function = commands[0];
            String[] args = (String[])ArrayUtils.subarray((Object[])commands, (int)1, (int)commands.length);
            commandParamsList.add(new CommandParams(function, args, commandStep));
        }
        return commandParamsList;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

