/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string.gson.format;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.annotation.AnnotationUtil;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.export.ExcelColumnDeclares;
import com.mini.framework.util.params.MapParams;
import com.mini.framework.util.string.RegexUtil;
import com.mini.framework.util.string.gson.format.CommandParams;
import com.mini.framework.util.string.gson.format.ExplainAliasCommandParams;
import com.mini.framework.util.string.gson.format.ExportResourceFromByte;
import com.mini.framework.util.string.gson.format.FormatAlias;
import com.mini.framework.util.string.gson.format.GsonDataFormatBean;
import com.mini.framework.util.string.gson.format.ResponseFormat;
import com.mini.framework.util.string.gson.format.bean.Concat;
import com.mini.framework.util.string.gson.format.bean.Fill;
import com.mini.framework.util.string.gson.format.bean.Json;
import com.mini.framework.util.string.gson.format.bean.Mapper;
import com.mini.framework.util.string.gson.format.bean.Merge;
import com.mini.framework.util.string.gson.format.bean.MergeList;
import com.mini.framework.util.string.gson.format.bean.Remove;
import com.mini.framework.util.string.gson.format.bean.Rename;
import com.mini.framework.util.string.gson.format.bean.Retain;
import com.mini.framework.util.string.gson.format.bean.Union;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

@Aspect
public abstract class ResponseFormatAnnotationSupport {
    public static final String defaultDataFormatKey = "dataFormat";

    @Pointcut(value="@annotation(com.mini.framework.util.string.gson.format.ResponseFormat)")
    public void methodPoint() {
    }

    @Around(value="methodPoint()")
    @Order(value=100)
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        this.findAnnotation((JoinPoint)joinPoint, ResponseFormat.class).orElseThrow(() -> new ServerException("\u6ca1\u6709\u53d1\u73b0\u6ce8\u89e3%s", new Object[]{ResponseFormat.class}));
        List<ResponseFormat> responseFormats = ResponseFormatAnnotationSupport.findDeepUsefulResponseFormats(joinPoint);
        AssertUtil.assertNotFatalBug(!responseFormats.isEmpty(), "\u81f3\u5c11\u8981\u6709\u4e00\u4e2a\u53ef\u7528\u7684\u54cd\u5e94\u6ce8\u89e3:%s", ResponseFormat.class);
        List<ExcelColumnDeclares> excelColumnDeclaresList = ResponseFormatAnnotationSupport.findDeepExcelColumnDeclaresList(joinPoint);
        Optional<String> dataFormatParamOptional = this.queryDataFormatParam();
        Object originResult = joinPoint.proceed();
        return dataFormatParamOptional.map(dataFormatParam -> {
            AssertUtil.assertNotFatalProgramConfig(originResult != null, Status.Server.programConfigJava, "\u8fd4\u56de\u503c\u4e3a\u7a7a\u7684\u4e0d\u5141\u8bb8\u4f7f\u7528\u683c\u5f0f\u5904\u7406\u5668", new Object[0]);
            AssertUtil.assertNotFatalProgramConfig(!(originResult instanceof String), Status.Server.programConfigJava, "\u8fd4\u56de\u503c\u5b57\u7b26\u4e32\u7684\u4e0d\u5141\u8bb8\u4f7f\u7528\u683c\u5f0f\u5904\u7406\u5668,originResult:%s", originResult);
            return this.applyFormat(originResult, (String)dataFormatParam, responseFormats, excelColumnDeclaresList);
        }).orElse(originResult);
    }

    private static List<ResponseFormat> findDeepUsefulResponseFormats(ProceedingJoinPoint joinPoint) {
        AnnotatedElement targetMethodElement = ResponseFormatAnnotationSupport.findPointAnnotationElement((JoinPoint)joinPoint);
        ArrayList<ResponseFormat> foundResponseFormats = AnnotationUtil.findElementDeepSortedAnnotationsDistinct(targetMethodElement, ResponseFormat.class);
        return ResponseFormat.Support.retainUsefulByWorkScheme(foundResponseFormats);
    }

    private static List<ExcelColumnDeclares> findDeepExcelColumnDeclaresList(ProceedingJoinPoint joinPoint) {
        AnnotatedElement targetMethodElement = ResponseFormatAnnotationSupport.findPointAnnotationElement((JoinPoint)joinPoint);
        return AnnotationUtil.findElementDeepSortedAnnotationsDistinct(targetMethodElement, ExcelColumnDeclares.class);
    }

    public Object applyFormat(Object origin, String dataFormatParam, List<ResponseFormat> aliasAnnotation, List<ExcelColumnDeclares> excelColumnDeclaresList) {
        AssertUtil.assertNoBadReq(dataFormatParam.length() != 0, Status.BadReq.illParam, "dataFormat\u53c2\u6570\u957f\u5ea6\u4e0d\u80fd\u4e3a0", new Object[0]);
        LinkedHashMap<String, String> aliasMapper = this.findResponseFormatAliases(aliasAnnotation);
        String explainForApply = this.applyPrepareExplainAliases(dataFormatParam, aliasMapper);
        ExportResourceFromByte resourceExportFunction = this.showResourceExportFunction();
        AssertUtil.assertNotFatalBug(resourceExportFunction != null, "\u53c2\u6570 showResourceExportFunction() \u4e0d\u80fd\u8fd4\u56de\u7a7a", new Object[0]);
        GsonDataFormatBean gsonBean = GsonDataFormatBean.build(this.showResourceExportFunction(), excelColumnDeclaresList, origin);
        gsonBean.addRootProperty("responseFormatDescribe", this.createExplainDescribe(explainForApply, aliasAnnotation));
        gsonBean.applyCommandsFromExplain(explainForApply);
        String stringResult = gsonBean.createString();
        this.afterDataFormat(stringResult);
        return stringResult;
    }

    private MapParams createExplainDescribe(String explainForApply, List<ResponseFormat> aliasAnnotations) {
        LinkedHashMap<String, String> aliasMapper = this.findResponseFormatAliases(aliasAnnotations);
        List<ExplainAliasCommandParams> list = ExplainAliasCommandParams.createFromAliasExplainMapper(aliasMapper);
        return MapParams.build().param("schemes", aliasAnnotations.stream().map(ResponseFormat::name).collect(Collectors.toList())).param("applyCommandExplain", explainForApply).param("prepareAliasExplainMapper", aliasMapper).param("applyCommandList", CommandParams.resolverExplainWithDescribe(explainForApply)).param("prepareAliasExplainList", list);
    }

    private LinkedHashMap<String, String> findResponseFormatAliases(List<ResponseFormat> aliasAnnotations) {
        return aliasAnnotations.stream().map(this::findResponseFormatAliases).reduce(new LinkedHashMap(), (prev, next) -> {
            next.putAll(prev);
            return next;
        });
    }

    private LinkedHashMap<String, String> findResponseFormatAliases(ResponseFormat aliasAnnotation) {
        String actionSplit = "/";
        FormatAlias[] aliases = aliasAnnotation.value();
        LinkedHashMap<String, String> aliasExplainMapper = new LinkedHashMap<String, String>();
        for (FormatAlias responseFormatAlias : aliases) {
            Object[] paramObjects = responseFormatAlias.params();
            String alias = responseFormatAlias.alias();
            AssertUtil.assertSupport(aliasExplainMapper.get(alias) == null, "alias:[%s]\u91cd\u590d\u4e86", alias);
            Merge[] merges = responseFormatAlias.merge();
            MergeList[] mergeLists = responseFormatAlias.mergeList();
            Remove[] removes = responseFormatAlias.remove();
            Union[] unions = responseFormatAlias.union();
            Mapper[] mappers = responseFormatAlias.mapper();
            Concat[] concats = responseFormatAlias.concat();
            Fill[] fills = responseFormatAlias.fill();
            Rename[] renames = responseFormatAlias.rename();
            Json[] jsons = responseFormatAlias.json();
            Retain[] retains = responseFormatAlias.retain();
            LinkedHashMap<String, Annotation[]> commands = new LinkedHashMap<String, Annotation[]>();
            commands.put("merge", merges);
            commands.put("mergeList", mergeLists);
            commands.put("remove", removes);
            commands.put("json", jsons);
            commands.put("union", unions);
            commands.put("mapper", mappers);
            commands.put("concat", concats);
            commands.put("fills", fills);
            commands.put("renames", renames);
            commands.put("retains", retains);
            Object[] keys = commands.entrySet().stream().filter(command -> ((Object[])command.getValue()).length > 0).map(Map.Entry::getKey).toArray();
            CharSequence[] explainItems = responseFormatAlias.explain();
            if (explainItems.length > 0) {
                AssertUtil.assertSupport(keys.length == 0, "alias:[%s]\u4e2d\u5982\u679c\u5199\u4e86explain:[%s]\u4e0d\u5141\u8bb8\u518d\u4f7f\u7528%s", alias, String.join((CharSequence)",", explainItems), Arrays.toString(keys));
                String explain = Stream.of(explainItems).map(explainItem -> MessageFormat.format(explainItem, paramObjects)).collect(Collectors.joining(actionSplit));
                aliasExplainMapper.put(alias, explain);
                continue;
            }
            AssertUtil.assertSupport(keys.length > 0, "alias:[%s]\u4e2d\u627e\u4e0d\u5230 explain \u5fc5\u987b\u6539\u547d\u4ee4\u6ce8\u89e3", alias);
            ArrayList<String> explains = new ArrayList<String>();
            for (Merge merge : merges) {
                explains.add(this.showExplain(merge));
            }
            for (Annotation annotation : mergeLists) {
                explains.add(this.showExplain((MergeList)annotation));
            }
            for (Annotation annotation : removes) {
                explains.add(this.showExplain((Remove)annotation));
            }
            for (Annotation annotation : unions) {
                explains.add(this.showExplain((Union)annotation));
            }
            for (Annotation annotation : mappers) {
                explains.add(this.showExplain((Mapper)annotation));
            }
            for (Annotation annotation : concats) {
                explains.add(this.showExplain((Concat)annotation));
            }
            for (Annotation annotation : fills) {
                explains.add(this.showExplain((Fill)annotation));
            }
            for (Annotation annotation : renames) {
                explains.add(this.showExplain((Rename)annotation));
            }
            for (Annotation annotation : jsons) {
                explains.add(this.showExplain((Json)annotation));
            }
            for (Annotation annotation : retains) {
                explains.add(this.showExplain((Retain)annotation));
            }
            aliasExplainMapper.put(alias, StringUtils.join(explains.iterator(), (String)actionSplit));
        }
        return aliasExplainMapper;
    }

    private String applyPrepareExplainAliases(String explain, Map<String, String> aliases) {
        String preExplain;
        AssertUtil.assertMethodRequire(explain, "explain");
        do {
            preExplain = explain;
        } while (!(explain = RegexUtil.splitByPointEachHandle("\\||/", explain, item -> aliases.getOrDefault(item, (String)item))).equals(preExplain));
        return explain;
    }

    protected abstract Optional<String> queryDataFormatParam();

    protected void afterDataFormat(String ret) {
    }

    protected abstract ExportResourceFromByte showResourceExportFunction();

    private static <T extends Annotation> AnnotatedElement findPointAnnotationElement(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        return methodSignature.getMethod();
    }

    private <T extends Annotation> Optional<T> findAnnotation(JoinPoint joinPoint, Class<T> annotationClass) {
        AnnotatedElement targetMethod = ResponseFormatAnnotationSupport.findPointAnnotationElement(joinPoint);
        return Optional.ofNullable(targetMethod.getAnnotation(annotationClass));
    }

    public String showExplain(Merge merge) {
        AssertUtil.assertMethodRequire(merge, "merge");
        String explain = String.join((CharSequence)",", "merge", merge.targetPath(), merge.targetKey(), merge.soursePath(), merge.sourseKey(), merge.alias());
        return explain;
    }

    public String showExplain(MergeList mergeList) {
        AssertUtil.assertMethodRequire(mergeList, "mergeList");
        String explain = String.join((CharSequence)",", "mergeList", mergeList.targetPath(), mergeList.targetKey(), mergeList.soursePath(), mergeList.sourseKey(), mergeList.listAlias());
        return explain;
    }

    public String showExplain(Mapper mapper) {
        AssertUtil.assertMethodRequire(mapper, "mapper");
        String explain = String.join((CharSequence)",", "mapper", mapper.targetPath(), mapper.targetKey(), mapper.soursePath(), mapper.alias());
        return explain;
    }

    private String showExplain(Remove remove) {
        AssertUtil.assertMethodRequire(remove, "remove");
        AssertUtil.assertMethodRequire(remove.targetKeys().length > 0, "remove\u91cc\u7684targetKeys\u6570\u5fc5\u987b\u5927\u4e8e0");
        String explain = String.join((CharSequence)",", "remove", remove.targetPath(), String.join((CharSequence)",", remove.targetKeys()));
        return explain;
    }

    private String showExplain(Union union) {
        AssertUtil.assertMethodRequire(union, "union");
        AssertUtil.assertMethodRequire(union.retainKeys().length > 0, "union\u91cc\u7684retainKeys\u6570\u5fc5\u987b\u5927\u4e8e0");
        String explain = String.join((CharSequence)",", "union", union.targetPath(), union.targetKey(), union.soursePath(), union.sourseKey(), String.join((CharSequence)",", union.retainKeys()));
        return explain;
    }

    private String showExplain(Concat concat) {
        AssertUtil.assertMethodRequire(concat, "concat");
        AssertUtil.assertMethodRequire(concat.sourseKeys().length > 0, "concat\u91cc\u7684sourseKeys\u6570\u5fc5\u987b\u5927\u4e8e0");
        String explain = String.join((CharSequence)",", "concat", concat.soursePath(), concat.alias(), concat.nullValue(), concat.split(), String.join((CharSequence)",", concat.sourseKeys()));
        return explain;
    }

    private String showExplain(Fill fill) {
        AssertUtil.assertMethodRequire(fill, "fill");
        String explain = String.join((CharSequence)",", "fill", fill.targetPath(), fill.targetKey(), fill.value());
        return explain;
    }

    private String showExplain(Rename rename) {
        AssertUtil.assertMethodRequire(rename, "rename");
        String explain = String.join((CharSequence)",", "rename", rename.targetPath(), rename.targetKey(), rename.newName());
        return explain;
    }

    private String showExplain(Json json) {
        AssertUtil.assertMethodRequire(json, "json");
        String explain = String.join((CharSequence)",", "json", json.action().name(), json.targetPath(), json.targetKey(), json.alias());
        return explain;
    }

    private String showExplain(Retain retain) {
        AssertUtil.assertMethodRequire(retain, "remove");
        AssertUtil.assertMethodRequire(retain.targetKeys().length > 0, "retain\u91cc\u7684targetKeys\u6570\u5fc5\u987b\u5927\u4e8e0");
        String explain = String.join((CharSequence)",", "retain", retain.targetPath(), String.join((CharSequence)",", retain.targetKeys()));
        return explain;
    }
}

