/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.surplus.reduce;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ReduceQueueItem {
    private String timeRandom;
    private Date itemRecordDate;
    private Date lackExpireDate;

    public static ReduceQueueItem createLackItem(Date itemRecordDate, Date expireDate, long increment) {
        ReduceQueueItem item = ReduceQueueItem.createEffectiveItem(itemRecordDate);
        AssertUtil.assertMethodRequire(expireDate, "expireDate");
        item.setLackExpireDate(new Date(expireDate.getTime() + increment));
        return item;
    }

    public static ReduceQueueItem createEffectiveItem(Date itemRecordDate) {
        AssertUtil.assertMethodRequire(itemRecordDate, "itemRecordDate");
        ReduceQueueItem item = new ReduceQueueItem();
        String timeRandom = DateUtil.toMilSecondsNumeric(itemRecordDate) + StringUtils.leftPad((String)"0", (int)6, (String)String.valueOf(System.nanoTime() / 100000L));
        item.setTimeRandom(timeRandom);
        item.setItemRecordDate(itemRecordDate);
        return item;
    }

    public static List<ReduceQueueItem> createEffectiveItemArray(Date itemRecordDate, int size) {
        ArrayList<ReduceQueueItem> itemArray = new ArrayList<ReduceQueueItem>();
        IntStream.range(0, size).forEach(index -> itemArray.add(ReduceQueueItem.createEffectiveItem(itemRecordDate)));
        return itemArray;
    }

    public static List<ReduceQueueItem> createEffectiveAndLackItemArray(Date itemRecordDate, int effectiveSize, int lackSize, Date expireDate, long increment) {
        List<ReduceQueueItem> effectiveItemArray = ReduceQueueItem.createEffectiveItemArray(itemRecordDate, effectiveSize);
        List<ReduceQueueItem> lackItemArray = ReduceQueueItem.createLackItemArray(itemRecordDate, lackSize, new Date(), increment);
        ArrayList<ReduceQueueItem> allItemArray = new ArrayList<ReduceQueueItem>();
        allItemArray.addAll(effectiveItemArray);
        allItemArray.addAll(lackItemArray);
        return allItemArray;
    }

    public static List<ReduceQueueItem> createLackItemArray(Date itemRecordDate, int size, Date expireDate, long increment) {
        ArrayList<ReduceQueueItem> itemArray = new ArrayList<ReduceQueueItem>();
        IntStream.range(0, size).forEach(index -> itemArray.add(ReduceQueueItem.createLackItem(itemRecordDate, expireDate, increment)));
        return itemArray;
    }

    public boolean ifNotLack() {
        return !this.ifLack();
    }

    public boolean ifLack() {
        return this.lackExpireDate != null;
    }

    public boolean ifCompleteRecord() {
        return this.itemRecordDate != null;
    }

    public boolean ifLackAndExpire() {
        return this.ifLackAndExpire(new Date());
    }

    public boolean ifLackAndEffective() {
        return this.ifLackAndEffective(new Date());
    }

    public boolean ifLackAndEffective(Date now) {
        return this.ifLack() && this.lackExpireDate.after(now);
    }

    public boolean ifLackAndExpire(Date now) {
        return this.ifLack() && this.lackExpireDate.after(now);
    }

    public Date getLackExpireDate() {
        return this.lackExpireDate;
    }

    public void setLackExpireDate(Date lackExpireDate) {
        this.lackExpireDate = lackExpireDate;
    }

    public Date getItemRecordDate() {
        return this.itemRecordDate;
    }

    public void setItemRecordDate(Date itemRecordDate) {
        this.itemRecordDate = itemRecordDate;
    }

    public String getTimeRandom() {
        return this.timeRandom;
    }

    public void setTimeRandom(String timeRandom) {
        this.timeRandom = timeRandom;
    }

    public String toString() {
        return String.format("ifNotLack:[%s],ifLackAndExpire:[%s],ifLackAndEffective:[%s],%s", this.ifNotLack(), this.ifLackAndExpire(), this.ifLackAndEffective(), ToStringBuilder.reflectionToString((Object)this));
    }
}

