/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.thread;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.ArrayList;
import java.util.List;

public class AsyncThreadContextExtends {
    private final List<ContextTransfer<Integer>> intContextTransfers;
    private final List<ContextTransfer<Long>> longContextTransfers;
    private final List<ContextTransfer<Object>> objectContextTransfers;
    private final List<ContextTransfer<String>> stringContextTransfers;

    public AsyncThreadContextExtends(List<ContextTransfer<Integer>> intContextTransfers, List<ContextTransfer<Long>> longContextTransfers, List<ContextTransfer<Object>> objectContextTransfers, List<ContextTransfer<String>> stringContextTransfers) {
        this.intContextTransfers = intContextTransfers;
        this.longContextTransfers = longContextTransfers;
        this.objectContextTransfers = objectContextTransfers;
        this.stringContextTransfers = stringContextTransfers;
        AssertUtil.assertMethodRequire(intContextTransfers, "intContextTransfers");
        AssertUtil.assertMethodRequire(longContextTransfers, "longContextTransfers");
        AssertUtil.assertMethodRequire(objectContextTransfers, "objectContextTransfers");
        AssertUtil.assertMethodRequire(stringContextTransfers, "stringContextTransfers");
    }

    public ContextCache createFromMainThread() {
        return new ContextCache(this);
    }

    public static class ContextCache {
        private final List<Integer> intCaches;
        private final List<Long> longCaches;
        private final List<String> stringCaches;
        private final List<Object> objectCaches;
        private final AsyncThreadContextExtends contextExtends;

        private ContextCache(AsyncThreadContextExtends contextExtends) {
            int index;
            this.contextExtends = contextExtends;
            this.intCaches = new ArrayList<Integer>();
            this.longCaches = new ArrayList<Long>();
            this.stringCaches = new ArrayList<String>();
            this.objectCaches = new ArrayList<Object>();
            for (index = 0; index < contextExtends.intContextTransfers.size(); ++index) {
                ContextTransfer intTransfer = (ContextTransfer)contextExtends.intContextTransfers.get(index);
                this.intCaches.add((Integer)intTransfer.read());
            }
            for (index = 0; index < contextExtends.longContextTransfers.size(); ++index) {
                ContextTransfer longTransfer = (ContextTransfer)contextExtends.longContextTransfers.get(index);
                this.longCaches.add((Long)longTransfer.read());
            }
            for (index = 0; index < contextExtends.stringContextTransfers.size(); ++index) {
                ContextTransfer stringTransfer = (ContextTransfer)contextExtends.stringContextTransfers.get(index);
                this.stringCaches.add((String)stringTransfer.read());
            }
            for (index = 0; index < contextExtends.objectContextTransfers.size(); ++index) {
                ContextTransfer objectTransfer = (ContextTransfer)contextExtends.objectContextTransfers.get(index);
                this.objectCaches.add(objectTransfer.read());
            }
        }

        public void applyToThread() {
            Object intCache;
            int index;
            for (index = 0; index < this.contextExtends.intContextTransfers.size(); ++index) {
                ContextTransfer intTransfer = (ContextTransfer)this.contextExtends.intContextTransfers.get(index);
                intCache = this.intCaches.get(index);
                intTransfer.write(intCache);
            }
            for (index = 0; index < this.contextExtends.longContextTransfers.size(); ++index) {
                ContextTransfer longTransfer = (ContextTransfer)this.contextExtends.longContextTransfers.get(index);
                Long longCache = this.longCaches.get(index);
                longTransfer.write(longCache);
            }
            for (index = 0; index < this.contextExtends.stringContextTransfers.size(); ++index) {
                ContextTransfer stringTransfer = (ContextTransfer)this.contextExtends.stringContextTransfers.get(index);
                intCache = this.stringCaches.get(index);
                stringTransfer.write(intCache);
            }
            for (index = 0; index < this.contextExtends.objectContextTransfers.size(); ++index) {
                ContextTransfer objectTransfer = (ContextTransfer)this.contextExtends.objectContextTransfers.get(index);
                Object objectCache = this.objectCaches.get(index);
                objectTransfer.write(objectCache);
            }
        }
    }

    public static interface ContextTransfer<T> {
        public T read();

        public void write(T var1);
    }
}

